/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.graalvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;

public class ReflectiveClass
implements JsonSerialization {
    final Class<?> clazz;
    final Constructor<?>[] constructors;
    final Field[] fields;
    final Method[] methods;

    public static ReflectiveClass of(Class<?> clazz) {
        return ReflectiveClass.of(clazz, false, false);
    }

    public static ReflectiveClass of(Class<?> clazz, boolean allFields, boolean allMethods) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Field[] fields = allFields ? ReflectiveClass.getAllFields(clazz) : new Field[]{};
        Method[] methods = allMethods ? ReflectiveClass.getAllMethods(clazz) : new Method[]{};
        return new ReflectiveClass(clazz, constructors, fields, methods);
    }

    private static Field[] getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        return fields.toArray(new Field[0]);
    }

    private static Method[] getAllMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(type.getDeclaredMethods()));
        return methods.toArray(new Method[0]);
    }

    public ReflectiveClass(Class<?> clazz, Constructor<?>[] constructors, Field[] fields, Method[] methods) {
        this.clazz = clazz;
        this.constructors = constructors;
        this.fields = fields;
        this.methods = methods;
    }

    public void register() {
        RuntimeReflection.register((Class[])new Class[]{this.clazz});
        RuntimeReflection.register((Executable[])this.constructors);
        RuntimeReflection.register((Field[])this.fields);
        RuntimeReflection.register((Executable[])this.methods);
    }

    public Json toJson() {
        Json j = Json.object();
        j.set("name", (Object)this.clazz.getName());
        if (this.fields.length > 0) {
            j.set("fields", Json.make(Arrays.stream(this.fields).map(f -> Json.object().set("name", (Object)f.getName())).collect(Collectors.toList())));
        }
        if (this.constructors.length > 0 || this.methods.length > 0) {
            Json methodArray = Json.array();
            for (Constructor<?> constructor : this.constructors) {
                methodArray.add(Json.object().set("name", (Object)"<init>").set("parameterTypes", Json.make(Arrays.stream(constructor.getParameterTypes()).map(Class::getName).collect(Collectors.toList()))));
            }
            for (Executable executable : this.methods) {
                methodArray.add(Json.object().set("name", (Object)((Method)executable).getName()).set("parameterTypes", Json.make(Arrays.stream(((Method)executable).getParameterTypes()).map(Class::getName).collect(Collectors.toList()))));
            }
            j.set("methods", methodArray);
        }
        return j;
    }
}

