/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.util.Arrays;
import java.util.Objects;
import org.infinispan.commons.test.skip.OS;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipJunit
implements TestRule {
    private final OS[] oses;

    public SkipJunit(OS ... oses) {
        this.oses = Objects.requireNonNull(oses);
    }

    public Statement apply(Statement base, Description description) {
        OS os = OS.getCurrentOs();
        if (!Arrays.asList(this.oses).contains((Object)os)) {
            return base;
        }
        return new IgnoreStatement(description, os);
    }

    public static void skipOnOS(OS ... oses) {
        OS os = OS.getCurrentOs();
        if (Arrays.asList(oses).contains((Object)os)) {
            throw new AssumptionViolatedException("Skipping test on " + (Object)((Object)os));
        }
    }

    private static class IgnoreStatement
    extends Statement {
        private final Description method;
        private final OS os;

        IgnoreStatement(Description method, OS os) {
            this.method = method;
            this.os = os;
        }

        public void evaluate() {
            String msg = "Skipping test " + this.method.getDisplayName() + " on " + (Object)((Object)this.os);
            System.out.println(msg);
            throw new AssumptionViolatedException(msg);
        }
    }
}

