/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.junit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.junit.rules.ExternalResource;

public class Cleanup
extends ExternalResource {
    private static final Logger log = Logger.getLogger(Cleanup.class);
    private final Deque<AutoCloseable> stack = new ArrayDeque<AutoCloseable>();

    public Cleanup() {
    }

    public Cleanup(AutoCloseable resource) {
        this.stack.push(resource);
    }

    public Cleanup(AutoCloseable resource1, AutoCloseable resource2) {
        this.stack.push(resource1);
        this.stack.push(resource2);
    }

    public Cleanup(Supplier<? extends AutoCloseable> supplier) {
        this.stack.push(new SupplierCloser(supplier));
    }

    public Cleanup(Supplier<? extends AutoCloseable> supplier1, Supplier<? extends AutoCloseable> supplier2) {
        this.stack.push(new SupplierCloser(supplier1));
        this.stack.push(new SupplierCloser(supplier2));
    }

    protected void after() {
        while (!this.stack.isEmpty()) {
            AutoCloseable resource = this.stack.pop();
            try {
                resource.close();
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to close resource %s", (Object)resource);
            }
        }
    }

    public <T extends AutoCloseable> T add(T resource) {
        this.stack.push(resource);
        return resource;
    }

    public <T extends AutoCloseable> void add(T resource1, T resource2) {
        this.stack.push(resource1);
        this.stack.push(resource2);
    }

    public <T> T add(ExceptionConsumer<T> closer, T resource) {
        this.stack.push(new NamedCloser<T>(closer, resource));
        return resource;
    }

    public <T> void add(ExceptionConsumer<T> closer, T resource1, T resource2) {
        this.stack.push(new NamedCloser<T>(closer, resource1));
        this.stack.push(new NamedCloser<T>(closer, resource2));
    }

    public static interface ExceptionConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static class SupplierCloser
    implements AutoCloseable {
        private final Supplier<? extends AutoCloseable> supplier;

        SupplierCloser(Supplier<? extends AutoCloseable> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void close() throws Exception {
            this.supplier.get().close();
        }

        public String toString() {
            return String.valueOf(this.supplier.get());
        }
    }

    private static class NamedCloser<T>
    implements AutoCloseable {
        private final ExceptionConsumer<T> closer;
        private final T resource;

        NamedCloser(ExceptionConsumer<T> closer, T resource) {
            this.closer = closer;
            this.resource = resource;
        }

        @Override
        public void close() throws Exception {
            this.closer.accept(this.resource);
        }

        public String toString() {
            return this.resource.toString();
        }
    }
}

