/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.test.EnvironmentCheck;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;

@Test(groups={"unit", "smoke"}, testName="test.fwk.TestNGSuiteChecksTest")
public class TestNGSuiteChecksTest {
    private static final Set<String> REQUIRED_GROUPS = new HashSet<String>(Arrays.asList("unit", "functional", "xsite", "arquillian", "stress", "profiling", "manual", "unstable"));
    private static final Set<String> ALLOWED_GROUPS = new HashSet<String>(Arrays.asList("unit", "functional", "xsite", "arquillian", "stress", "profiling", "manual", "unstable", "smoke", "java11", "transaction"));

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        EnvironmentCheck.checkJVMVersion();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<Class> classes = new HashSet<Class>();
        this.checkAnnotations(errors, classes, context.getSuite().getExcludedMethods());
        this.checkAnnotations(errors, classes, context.getSuite().getAllMethods());
        if (!errors.isEmpty()) {
            throw new AssertionError((Object)String.join((CharSequence)"\n", errors));
        }
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite() {
        ThreadLeakChecker.checkForLeaks("");
    }

    private void checkAnnotations(List<String> errors, Set<Class> classes, Collection<ITestNGMethod> methods) {
        for (ITestNGMethod m : methods) {
            this.checkMethodAnnotations(errors, m);
            this.checkClassAnnotations(errors, classes, m);
        }
    }

    private void checkMethodAnnotations(List<String> errors, ITestNGMethod m) {
        if (!m.getEnabled()) {
            return;
        }
        boolean hasRequiredGroup = false;
        for (String g : m.getGroups()) {
            if (!ALLOWED_GROUPS.contains(g)) {
                errors.add("Method " + m.getConstructorOrMethod() + " and/or its class has a @Test annotation with the wrong group: " + g + ".\nAllowed groups are " + ALLOWED_GROUPS);
                return;
            }
            if (!REQUIRED_GROUPS.contains(g)) continue;
            hasRequiredGroup = true;
        }
        if (!hasRequiredGroup) {
            errors.add("Method " + m.getConstructorOrMethod() + " and/or its class don't have any required group.\nRequired groups are " + REQUIRED_GROUPS);
            return;
        }
        Class testClass = m.getRealClass();
        Class declaringClass = m.getConstructorOrMethod().getDeclaringClass();
        Test annotation = testClass.getAnnotation(Test.class);
        if (testClass != declaringClass && !Arrays.equals(annotation.groups(), m.getGroups())) {
            errors.add("Method " + m.getConstructorOrMethod() + " was inherited from class " + declaringClass + " with groups " + Arrays.toString(m.getGroups()) + ", but the test class has groups " + Arrays.toString(annotation.groups()));
        }
    }

    private void checkClassAnnotations(List<String> errors, Set<Class> processedClasses, ITestNGMethod m) {
        Class xmlClass;
        Class testClass = m.getTestClass().getRealClass();
        if (m.getXmlTest().getXmlClasses().size() == 1 && (xmlClass = ((XmlClass)m.getXmlTest().getXmlClasses().get(0)).getSupportClass()) != testClass && processedClasses.add(xmlClass)) {
            errors.add("Class " + xmlClass.getName() + " must override the @Factory method from base class " + testClass.getName());
            return;
        }
        if (!processedClasses.add(testClass)) {
            return;
        }
        Test annotation = testClass.getAnnotation(Test.class);
        if (annotation == null || annotation.testName().isEmpty()) {
            errors.add("Class " + testClass.getName() + " does not have a testName");
            return;
        }
        if (!annotation.testName().contains(testClass.getSimpleName())) {
            errors.add("Class " + testClass.getName() + " has an invalid testName: " + annotation.testName());
        }
    }
}

