/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.test.PrettyXMLStreamWriter;

public class PolarionJUnitXMLWriter
implements AutoCloseable {
    private final FileWriter fileWriter;
    private static final String TESTSUITE = "testsuite";
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SKIPPED = "skipped";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String TESTCASE = "testcase";
    private static final String FAILURE = "failure";
    private static final String ERROR = "error";
    private static final String SKIPPED = "skipped";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final char UNICODE_REPLACEMENT = '\ufffd';
    private static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private XMLStreamWriter xmlWriter;

    public PolarionJUnitXMLWriter(File outputFile) throws IOException {
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IllegalStateException("Unable to create report directory " + outputDirectory);
        }
        this.fileWriter = new FileWriter(outputFile);
    }

    public void start(String moduleName, long testCount, long skippedCount, long failedCount, long elapsedTime, boolean includeProperties) throws XMLStreamException {
        this.xmlWriter = new PrettyXMLStreamWriter(xmlOutputFactory.createXMLStreamWriter(this.fileWriter));
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeCharacters("\n");
        this.xmlWriter.writeComment("Generated by " + this.getClass().getName());
        this.xmlWriter.writeStartElement(TESTSUITE);
        this.xmlWriter.writeAttribute(ATTR_TESTS, "" + testCount);
        this.xmlWriter.writeAttribute(ATTR_TIME, "" + (double)elapsedTime / 1000.0);
        this.xmlWriter.writeAttribute(ATTR_NAME, moduleName);
        this.xmlWriter.writeAttribute("skipped", "" + skippedCount);
        this.xmlWriter.writeAttribute(ATTR_ERRORS, "0");
        this.xmlWriter.writeAttribute(ATTR_FAILURES, "" + failedCount);
        if (includeProperties) {
            this.writeProperties();
        }
        this.xmlWriter.writeComment("Tests results");
    }

    @Override
    public void close() throws Exception {
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndDocument();
        this.xmlWriter.close();
        this.fileWriter.close();
    }

    public void writeTestCase(String testName, String className, long elapsedTimeMillis, Status status, String stackTrace, String throwableClass, String throwableMessage) throws XMLStreamException {
        String elapsedTime = "" + (double)elapsedTimeMillis / 1000.0;
        if (Status.SUCCESS == status) {
            this.xmlWriter.writeEmptyElement(TESTCASE);
        } else {
            this.xmlWriter.writeStartElement(TESTCASE);
        }
        this.xmlWriter.writeAttribute(ATTR_NAME, testName);
        this.xmlWriter.writeAttribute(ATTR_CLASSNAME, className);
        this.xmlWriter.writeAttribute(ATTR_TIME, elapsedTime);
        if (Status.SUCCESS != status) {
            switch (status) {
                case FAILURE: {
                    this.writeCauseElement(FAILURE, throwableClass, throwableMessage, stackTrace);
                    break;
                }
                case ERROR: {
                    this.writeCauseElement(ERROR, throwableClass, throwableMessage, stackTrace);
                    break;
                }
                case SKIPPED: {
                    this.writeSkipElement();
                }
            }
            this.xmlWriter.writeEndElement();
        }
    }

    private void writeCauseElement(String tag, String throwableClass, String message, String stackTrace) throws XMLStreamException {
        this.xmlWriter.writeStartElement(tag);
        this.xmlWriter.writeAttribute(ATTR_TYPE, throwableClass);
        if (message != null && message.length() > 0) {
            this.xmlWriter.writeAttribute(ATTR_MESSAGE, this.escapeInvalidChars(message));
        }
        this.xmlWriter.writeCData(stackTrace);
        this.xmlWriter.writeEndElement();
    }

    private void writeSkipElement() throws XMLStreamException {
        this.xmlWriter.writeEmptyElement("skipped");
    }

    private String escapeInvalidChars(String chars) {
        return chars.codePoints().map(c -> {
            if (!Character.isDefined(c) || 1 <= c && c <= 8 || c == 11 || c == 12 || 14 <= c && c <= 31 || 127 <= c && c < 132 || 134 <= c && c <= 159) {
                return 65533;
            }
            return c;
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private void writeProperties() throws XMLStreamException {
        this.xmlWriter.writeStartElement(PROPERTIES);
        this.xmlWriter.writeComment("Java System properties");
        for (Object object : System.getProperties().keySet()) {
            this.xmlWriter.writeEmptyElement(PROPERTY);
            this.xmlWriter.writeAttribute(ATTR_NAME, object.toString());
            this.xmlWriter.writeAttribute(ATTR_VALUE, System.getProperty(object.toString()));
        }
        this.xmlWriter.writeComment("Environment variables");
        for (String string : System.getenv().keySet()) {
            this.xmlWriter.writeEmptyElement(PROPERTY);
            this.xmlWriter.writeAttribute(ATTR_NAME, string);
            this.xmlWriter.writeAttribute(ATTR_VALUE, System.getenv(string));
        }
        this.xmlWriter.writeEndElement();
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        ERROR,
        SKIPPED;

    }
}

