/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.test.PolarionJUnitTest;
import org.infinispan.commons.test.PrettyXMLStreamWriter;

public class PolarionJUnitXMLWriter
implements AutoCloseable {
    private final FileWriter fileWriter;
    private static final String TESTSUITE = "testsuite";
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SKIPPED = "skipped";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String TESTCASE = "testcase";
    private static final String FAILURE = "failure";
    private static final String RERUN_FAILURE = "rerunFailure";
    private static final String FLAKY_FAILURE = "flakyFailure";
    private static final String ERROR = "error";
    private static final String SKIPPED = "skipped";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String STACKTRACE = "stackTrace";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final char UNICODE_REPLACEMENT = '\ufffd';
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private XMLStreamWriter xmlWriter;
    private static final Map<Character, String> ESCAPES = new HashMap<Character, String>();

    public PolarionJUnitXMLWriter(File outputFile) throws IOException {
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IllegalStateException("Unable to create report directory " + String.valueOf(outputDirectory));
        }
        this.fileWriter = new FileWriter(outputFile);
    }

    public void start(String testsuiteName, long testCount, long skippedCount, long failedCount, long elapsedTime, boolean includeProperties) throws XMLStreamException {
        this.xmlWriter = new PrettyXMLStreamWriter(xmlOutputFactory.createXMLStreamWriter(this.fileWriter));
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeCharacters("\n");
        this.xmlWriter.writeComment("Generated by " + this.getClass().getName());
        this.xmlWriter.writeStartElement(TESTSUITE);
        this.xmlWriter.writeAttribute(ATTR_TESTS, "" + testCount);
        this.xmlWriter.writeAttribute(ATTR_TIME, "" + (double)elapsedTime / 1000.0);
        this.xmlWriter.writeAttribute(ATTR_NAME, testsuiteName);
        this.xmlWriter.writeAttribute("skipped", "" + skippedCount);
        this.xmlWriter.writeAttribute(ATTR_ERRORS, "0");
        this.xmlWriter.writeAttribute(ATTR_FAILURES, "" + failedCount);
        if (includeProperties) {
            this.writeProperties();
        }
        this.xmlWriter.writeComment("Tests results");
    }

    @Override
    public void close() throws Exception {
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndDocument();
        this.xmlWriter.close();
        this.fileWriter.close();
    }

    public void writeTestCase(PolarionJUnitTest test) throws XMLStreamException {
        PolarionJUnitTest.Status status = test.status;
        if (status == PolarionJUnitTest.Status.SUCCESS) {
            this.xmlWriter.writeEmptyElement(TESTCASE);
            this.writeTestAttributes(test);
            return;
        }
        this.xmlWriter.writeStartElement(TESTCASE);
        this.writeTestAttributes(test);
        switch (test.status) {
            case FLAKY: {
                this.writeCauseElements(FLAKY_FAILURE, test.failures);
                break;
            }
            case ERROR: {
                this.writeCauseElements(ERROR, test.failures);
                break;
            }
            case FAILURE: {
                this.writeCauseElement(FAILURE, test.failures.get(0));
                this.writeCauseElements(RERUN_FAILURE, test.failures.subList(1, test.failures.size()));
                break;
            }
            case SKIPPED: {
                this.xmlWriter.writeEmptyElement("skipped");
            }
        }
        this.xmlWriter.writeEndElement();
    }

    public void writeTestAttributes(PolarionJUnitTest test) throws XMLStreamException {
        this.xmlWriter.writeAttribute(ATTR_NAME, test.name);
        this.xmlWriter.writeAttribute(ATTR_CLASSNAME, test.clazz);
        this.xmlWriter.writeAttribute(ATTR_TIME, Double.toString((double)test.elapsedTime() / 1000.0));
    }

    private void writeCauseElements(String tag, Collection<Throwable> throwables) throws XMLStreamException {
        for (Throwable t : throwables) {
            this.writeCauseElement(tag, t);
        }
    }

    private void writeCauseElement(String tag, Throwable throwable) throws XMLStreamException {
        String throwableClass = throwable.getClass().getName();
        String message = throwable.getMessage();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        String stackTrace = PolarionJUnitXMLWriter.escapeHtml(sw.toString());
        this.xmlWriter.writeStartElement(tag);
        this.xmlWriter.writeAttribute(ATTR_TYPE, throwableClass);
        if (message != null && !message.isEmpty()) {
            this.xmlWriter.writeAttribute(ATTR_MESSAGE, this.escapeInvalidChars(message));
        }
        this.xmlWriter.writeStartElement(STACKTRACE);
        this.xmlWriter.writeCData(stackTrace);
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndElement();
    }

    private String escapeInvalidChars(String chars) {
        return chars.codePoints().map(c -> {
            if (!Character.isDefined(c) || 1 <= c && c <= 8 || c == 11 || c == 12 || 14 <= c && c <= 31 || 127 <= c && c < 132 || 134 <= c && c <= 159) {
                return 65533;
            }
            return c;
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private void writeProperties() throws XMLStreamException {
        this.xmlWriter.writeStartElement(PROPERTIES);
        this.xmlWriter.writeComment("Java System properties");
        for (Object object : System.getProperties().keySet()) {
            this.xmlWriter.writeEmptyElement(PROPERTY);
            this.xmlWriter.writeAttribute(ATTR_NAME, object.toString());
            this.xmlWriter.writeAttribute(ATTR_VALUE, System.getProperty(object.toString()));
        }
        this.xmlWriter.writeComment("Environment variables");
        for (String string : System.getenv().keySet()) {
            this.xmlWriter.writeEmptyElement(PROPERTY);
            this.xmlWriter.writeAttribute(ATTR_NAME, string);
            this.xmlWriter.writeAttribute(ATTR_VALUE, System.getenv(string));
        }
        this.xmlWriter.writeEndElement();
    }

    public static String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String nc = ESCAPES.get(Character.valueOf(c));
            if (nc != null) {
                result.append(nc);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static {
        ESCAPES.put(Character.valueOf('<'), "&lt;");
        ESCAPES.put(Character.valueOf('>'), "&gt;");
        ESCAPES.put(Character.valueOf('\''), "&apos;");
        ESCAPES.put(Character.valueOf('\"'), "&quot;");
        ESCAPES.put(Character.valueOf('&'), "&amp;");
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        ERROR,
        SKIPPED;

    }
}

