/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.infinispan.commons.test.BlockHoundHelper;
import org.infinispan.commons.test.TestSuiteProgress;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsTestBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.addDynamicThreadPredicate(t -> t.getName().startsWith("main") || t.getName().startsWith("TestNG") || t.getName().startsWith("Time-limited test") || t.getName().startsWith("ForkThread"));
        builder.nonBlockingThreadPredicate(threadPredicate -> threadPredicate.or(t -> BlockHoundHelper.currentThreadRequiresNonBlocking()));
        CommonsTestBlockHoundIntegration.registerAllPublicMethodsOnClass(builder, TestSuiteProgress.class);
        builder.markAsBlocking(BlockHoundHelper.class, "blockingConsume", "(Ljava/lang/Object;)V");
    }

    private static void registerAllPublicMethodsOnClass(BlockHound.Builder builder, Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }
}

