/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class TestSuiteProgress {
    private static final Logger log = Logger.getLogger(TestSuiteProgress.class);
    private static AtomicInteger failed = new AtomicInteger(0);
    private static AtomicInteger succeeded = new AtomicInteger(0);
    private static AtomicInteger skipped = new AtomicInteger(0);

    static void testStarted(String name) {
        String message = "Test starting: " + name;
        TestSuiteProgress.consoleLog(message);
        log.info((Object)message);
    }

    static void testFinished(String name) {
        String message = "Test succeeded: " + name;
        TestSuiteProgress.consoleLog(message);
        log.info((Object)message);
        succeeded.incrementAndGet();
        TestSuiteProgress.printStatus();
    }

    static void testFailed(String name, Throwable exception) {
        String message = "Test failed: " + name;
        TestSuiteProgress.consoleLog(message);
        log.error((Object)message, exception);
        failed.incrementAndGet();
        TestSuiteProgress.printStatus();
    }

    static void testIgnored(String name) {
        String message = "Test ignored: " + name;
        TestSuiteProgress.consoleLog(message);
        log.info((Object)message);
        skipped.incrementAndGet();
        TestSuiteProgress.printStatus();
    }

    static void testAssumptionFailed(String name, Throwable exception) {
        String message = "Test assumption failed: " + name;
        TestSuiteProgress.consoleLog(message);
        log.info((Object)message, exception);
        skipped.incrementAndGet();
        TestSuiteProgress.printStatus();
    }

    static void setupFailed(String name, Throwable exception) {
        String message = "Test setup failed: " + name;
        TestSuiteProgress.consoleLog(message);
        log.error((Object)message, exception);
        failed.incrementAndGet();
        TestSuiteProgress.printStatus();
    }

    private static void printStatus() {
        String message = "Tests succeeded: " + succeeded.get() + ", failed: " + failed.get() + ", skipped: " + skipped.get();
        TestSuiteProgress.consoleLog(message);
    }

    private static void consoleLog(String message) {
        System.out.println("[" + TestSuiteProgress.class.getSimpleName() + "] " + message);
    }
}

