/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.infinispan.commons.test.skip.SkipOnOs;
import org.infinispan.commons.test.skip.SkipOnOsUtils;
import org.testng.IAnnotationTransformer;
import org.testng.annotations.ITestAnnotation;

public class SkipOnOsListener
implements IAnnotationTransformer {
    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        SkipOnOs annotationOnMethod;
        SkipOnOs annotationOnClass = testClass != null ? testClass.getAnnotation(SkipOnOs.class) : null;
        SkipOnOs skipOnOs = annotationOnMethod = testMethod != null ? testMethod.getAnnotation(SkipOnOs.class) : null;
        if (annotationOnMethod != null || annotationOnClass != null) {
            HashSet<SkipOnOs.OS> skipOnOs2 = new HashSet<SkipOnOs.OS>();
            if (annotationOnMethod != null) {
                skipOnOs2.addAll(Arrays.asList(annotationOnMethod.value()));
            }
            if (annotationOnClass != null) {
                skipOnOs2.addAll(Arrays.asList(annotationOnClass.value()));
            }
            if (skipOnOs2.contains((Object)SkipOnOsUtils.getOs())) {
                annotation.setEnabled(false);
                String msg = "Skipping " + (testMethod != null ? testMethod.getName() : (testClass != null ? testClass.getName() : null)) + " on " + skipOnOs2;
                annotation.setDescription(msg);
                System.out.println(msg);
            }
        }
    }
}

