/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class TestSuiteProgress {
    private static final Logger log = Logger.getLogger(TestSuiteProgress.class);
    private static final String RED = "\u001b[31m";
    private static final String GREEN = "\u001b[32m";
    private static final String YELLOW = "\u001b[33m";
    private static final String RESET = "\u001b[0m";
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger succeeded = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);
    private final PrintStream out;
    private final boolean useColor = !Boolean.getBoolean("ansi.strip");

    public TestSuiteProgress() {
        this.out = System.out;
    }

    void testStarted(String name) {
        String message = "Test starting: " + name;
        this.progress(message);
        log.info((Object)message);
    }

    void testFinished(String name) {
        this.succeeded.incrementAndGet();
        String message = "Test succeeded: " + name;
        this.progress(GREEN, message);
        log.info((Object)message);
    }

    void testFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test failed: " + name;
        this.progress(RED, message, exception);
        log.error((Object)message, exception);
    }

    void testIgnored(String name) {
        this.skipped.incrementAndGet();
        String message = "Test ignored: " + name;
        this.progress(YELLOW, message);
        log.info((Object)message);
    }

    void testAssumptionFailed(String name, Throwable exception) {
        this.skipped.incrementAndGet();
        String message = "Test assumption failed: " + name;
        this.progress(YELLOW, message, exception);
        log.info((Object)message, exception);
    }

    void setupFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test setup failed: " + name;
        this.progress(RED, message);
        log.error((Object)message, exception);
    }

    void progress(CharSequence message) {
        this.progress(null, message, null);
    }

    void progress(String color, CharSequence message) {
        this.progress(color, message, null);
    }

    synchronized void progress(String color, CharSequence message, Throwable t) {
        if (this.useColor && color != null) {
            this.out.print(color);
        }
        this.out.printf("[OK: %5s, KO: %5s, SKIP: %5s] %s%n", this.succeeded.get(), this.failed.get(), this.skipped.get(), message);
        if (t != null) {
            t.printStackTrace(this.out);
        }
        if (this.useColor && color != null) {
            this.out.print(RESET);
        }
    }
}

