/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging.log4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;
import org.infinispan.commons.logging.log4j.CompressedFileManager;

@Plugin(name="CompressedFile", category="Core", elementType="appender", printObject=true)
public final class CompressedFileAppender
extends AbstractOutputStreamAppender<FileManager> {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final String fileName;
    private final Advertiser advertiser;
    private Object advertisement;

    private CompressedFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, FileManager manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, (OutputStreamManager)manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(manager.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    public boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        if (changeLifeCycleState) {
            this.setStopped();
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    @PluginFactory
    public static CompressedFileAppender createAppender(@PluginAttribute(value="fileName") String fileName, @PluginAttribute(value="append") String append, @PluginAttribute(value="locking") String locking, @PluginAttribute(value="name") String name, @PluginAttribute(value="immediateFlush") String immediateFlush, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="bufferedIo") String bufferedIo, @PluginAttribute(value="bufferSize") String bufferSizeStr, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="advertise") String advertise, @PluginAttribute(value="advertiseUri") String advertiseUri, @PluginAttribute(value="compressionLevel", defaultInt=3) int compressionLevel, @PluginConfiguration Configuration config) {
        boolean isAppend = Booleans.parseBoolean((String)append, (boolean)true);
        boolean isLocking = Boolean.parseBoolean(locking);
        boolean isBuffered = Booleans.parseBoolean((String)bufferedIo, (boolean)true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        if (isLocking && isBuffered) {
            if (bufferedIo != null) {
                LOGGER.warn("Locking and buffering are mutually exclusive. No buffering will occur for " + fileName);
            }
            isBuffered = false;
        }
        int bufferSize = Integers.parseInt((String)bufferSizeStr, (int)8192);
        if (!isBuffered && bufferSize > 0) {
            LOGGER.warn("The bufferSize is set to {} but bufferedIO is not true: {}", (Object)bufferSize, (Object)bufferedIo);
        }
        boolean isFlush = Booleans.parseBoolean((String)immediateFlush, (boolean)true);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        if (name == null) {
            LOGGER.error("No name provided for CompressedFileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename provided for CompressedFileAppender with name {}", (Object)name);
            return null;
        }
        if (!fileName.endsWith(".gz")) {
            LOGGER.error("Filename {} does not end in .gz for CompressedFileAppender with name {}", (Object)fileName, (Object)name);
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (compressionLevel < 1 || 9 < compressionLevel) {
            LOGGER.error("compressionLevel {} is not between 1..9 for CompressedFileAppender with name {}", (Object)compressionLevel, (Object)name);
            return null;
        }
        CompressedFileManager manager = CompressedFileManager.getFileManager(fileName, isAppend, isLocking, isBuffered, advertiseUri, (Layout<? extends Serializable>)layout, bufferSize, compressionLevel);
        if (manager == null) {
            return null;
        }
        return new CompressedFileAppender(name, (Layout<? extends Serializable>)layout, filter, manager, fileName, ignoreExceptions, isFlush, isAdvertise ? config.getAdvertiser() : null);
    }
}

