/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.skip.OS;

class RunningTestsRegistry {
    private static final long MAX_TEST_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "RunningTestsRegistry-Worker"));
    private static final Map<Thread, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();

    RunningTestsRegistry() {
    }

    static void unregisterThreadWithTest() {
        ScheduledFuture<?> killTask = scheduledTasks.remove(Thread.currentThread());
        if (killTask != null) {
            killTask.cancel(false);
        }
    }

    static void registerThreadWithTest(String testName, String simpleName) {
        Thread testThread = Thread.currentThread();
        ScheduledFuture<?> future = executor.schedule(() -> RunningTestsRegistry.killLongTest(testThread, testName, simpleName), MAX_TEST_SECONDS, TimeUnit.SECONDS);
        scheduledTasks.put(testThread, future);
    }

    private static void killLongTest(Thread testThread, String testName, String simpleName) {
        String safeTestName = testName.replaceAll("[^a-zA-Z0-9=]", "_");
        List<String> pids = RunningTestsRegistry.collectChildProcesses(testName);
        RunningTestsRegistry.dumpThreads(safeTestName, pids);
        RunningTestsRegistry.killTest(testThread, pids);
    }

    private static List<String> collectChildProcesses(String testName) {
        try {
            System.err.printf("[ERROR] Test %s has been running for more than %d seconds. Interrupting the test thread and dumping threads of the test suite process and its children.\n", testName, MAX_TEST_SECONDS);
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            String ppid = jvmName.split("@")[0];
            ArrayList<String> pids = new ArrayList<String>(Collections.singletonList(ppid));
            for (int index = 0; index < pids.size(); ++index) {
                String pid = (String)pids.get(index);
                if (OS.getCurrentOs() == OS.WINDOWS) continue;
                Process ps = new ProcessBuilder(new String[0]).command("ps", "-o", "pid=,comm=", "--ppid", pid).start();
                try (BufferedReader psOutput = new BufferedReader(new InputStreamReader(ps.getInputStream()));){
                    psOutput.lines().forEach(line -> {
                        String[] pidAndCommand = line.split("\\s+");
                        if (!"ps".equals(pidAndCommand[1].trim())) {
                            pids.add(pidAndCommand[0].trim());
                        }
                    });
                }
                ps.waitFor(10L, TimeUnit.SECONDS);
            }
            return pids;
        }
        catch (Exception e) {
            System.err.println("Error collecting child processes:");
            e.printStackTrace(System.err);
            return Collections.emptyList();
        }
    }

    private static void dumpThreads(String safeTestName, List<String> pids) {
        block11: {
            try {
                String javaHome = System.getProperty("java.home");
                File jstackFile = new File(javaHome, "bin/jstack");
                if (!jstackFile.canExecute()) {
                    jstackFile = new File(javaHome, "../bin/jstack");
                }
                LocalDateTime now = LocalDateTime.now();
                if (jstackFile.canExecute() && !pids.isEmpty()) {
                    for (String pid : pids) {
                        File dumpFile = new File(String.format("threaddump-%1$s-%2$tY-%2$tm-%2$td-%3$s.log", safeTestName, now, pid));
                        System.out.printf("Dumping thread stacks of process %s to %s\n", pid, dumpFile.getAbsolutePath());
                        Process jstack = new ProcessBuilder(new String[0]).command(jstackFile.getAbsolutePath(), pid).redirectOutput(dumpFile).start();
                        jstack.waitFor(10L, TimeUnit.SECONDS);
                    }
                    break block11;
                }
                File dumpFile = new File(String.format("threaddump-%1$s-%2$tY-%2$tm-%2$td.log", safeTestName, now));
                System.out.printf("Cannot find jstack in %s, programmatically dumping thread stacks of testsuite process to %s\n", javaHome, dumpFile.getAbsolutePath());
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                try (PrintWriter writer = new PrintWriter(new FileWriter(dumpFile));){
                    ThreadInfo[] threads;
                    writer.printf("%1$tF %1$tT\nTest thread dump:\n\n", now);
                    for (ThreadInfo thread : threads = threadMXBean.dumpAllThreads(true, true)) {
                        RunningTestsRegistry.dumpThread(writer, thread);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error dumping threads:");
                e.printStackTrace(System.err);
            }
        }
    }

    private static void killTest(Thread testThread, List<String> pids) {
        try {
            testThread.interrupt();
            System.out.printf("Interrupted thread %s (%d).\n", testThread.getName(), testThread.getId());
            testThread.join(TimeUnit.SECONDS.toMillis(1L));
            if (testThread.isAlive()) {
                Process kill;
                if (OS.getCurrentOs() == OS.WINDOWS) {
                    ArrayList<String> command = new ArrayList<String>(Arrays.asList("taskkill", "/t", "/pid"));
                    for (String pid : pids) {
                        command.add("/pid");
                        command.add(pid);
                    }
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                } else {
                    ArrayList<String> command = new ArrayList<String>(Collections.singletonList("kill"));
                    command.addAll(pids);
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                }
                kill.waitFor(10L, TimeUnit.SECONDS);
                System.out.printf("Killed processes %s\n", String.join((CharSequence)" ", pids));
            }
        }
        catch (Exception e) {
            System.err.println("Error killing test:");
            e.printStackTrace(System.err);
        }
    }

    private static void dumpThread(PrintWriter writer, ThreadInfo thread) {
        writer.printf("\"%s\" #%s prio=0 tid=0x%x nid=NA %s\n", thread.getThreadName(), thread.getThreadId(), thread.getThreadId(), thread.getThreadState().toString().toLowerCase());
        writer.printf("   java.lang.Thread.State: %s\n", new Object[]{thread.getThreadState()});
        LockInfo blockedLock = thread.getLockInfo();
        StackTraceElement[] s = thread.getStackTrace();
        MonitorInfo[] monitors = thread.getLockedMonitors();
        for (int i = 0; i < s.length; ++i) {
            StackTraceElement ste = s[i];
            writer.printf("\tat %s\n", ste);
            if (i == 0 && blockedLock != null) {
                boolean parking = ste.isNativeMethod() && ste.getMethodName().equals("park");
                writer.printf("\t- %s <0x%x> (a %s)\n", RunningTestsRegistry.blockedState(thread, blockedLock, parking), blockedLock.getIdentityHashCode(), blockedLock.getClassName());
            }
            if (monitors == null) continue;
            MonitorInfo[] monitorInfoArray = monitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitor = monitorInfoArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                writer.printf("\t- locked <0x%x> (a %s)\n", monitor.getIdentityHashCode(), monitor.getClassName());
            }
        }
        writer.println();
        LockInfo[] synchronizers = thread.getLockedSynchronizers();
        if (synchronizers != null && synchronizers.length > 0) {
            writer.print("\n   Locked ownable synchronizers:\n");
            for (LockInfo synchronizer : synchronizers) {
                writer.printf("\t- <0x%x> (a %s)\n", synchronizer.getIdentityHashCode(), synchronizer.getClassName());
            }
            writer.println();
        }
    }

    private static String blockedState(ThreadInfo thread, LockInfo blockedLock, boolean parking) {
        String state = blockedLock != null ? (thread.getThreadState().equals((Object)Thread.State.BLOCKED) ? "waiting to lock" : (parking ? "parking to wait for" : "waiting on")) : null;
        return state;
    }
}

