/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class ThreadLeakChecker {
    private static final Pattern IGNORED_THREADS_REGEX = Pattern.compile("(testng-|RunningTestsRegistry-Worker|test-timeout-thread|Time-limited test|ForkJoinPool.commonPool-|RxCachedWorkerPoolEvictor|RxSchedulerPurge|globalEventExecutor|Transaction Reaper|Generate Seed|AtomicFactory-global|Keep-Alive-Timer|Attach Listener|Hibernate Search sync consumer thread for index|NioConnection.Reader|process reaper|XNIO-1 |ExpiringMapExpirer|RMI |Reference Reaper|remoting-jmx client|management-client-thread|ClassCache Reaper).*");
    private static final String ARQUILLIAN_CONSOLE_CONSUMER = "org.jboss.as.arquillian.container.managed.ManagedDeployableContainer$ConsoleConsumer";
    private static final boolean ENABLED = "true".equalsIgnoreCase(System.getProperty("infinispan.test.checkThreadLeaks", "true"));
    private static Logger log = Logger.getLogger(ThreadLeakChecker.class);
    private static volatile long lastUpdate = 0L;
    private static final Set<String> runningTests = ConcurrentHashMap.newKeySet();
    private static final BlockingQueue<String> finishedTests = new LinkedBlockingDeque<String>();
    private static final Map<Thread, LeakInfo> runningThreads = new ConcurrentHashMap<Thread, LeakInfo>();
    private static final Lock lock = new ReentrantLock();

    public static void testStarted(String testName) {
        lock.lock();
        try {
            runningTests.add(testName);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInitialThreads() {
        lock.lock();
        try {
            Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
            for (Thread thread : currentThreads) {
                LeakInfo leakInfo = new LeakInfo(thread, Collections.emptyList());
                leakInfo.ignore();
                runningThreads.putIfAbsent(thread, leakInfo);
            }
            lastUpdate = System.nanoTime();
        }
        finally {
            lock.unlock();
        }
    }

    public static void testFinished(String testName) {
        lock.lock();
        try {
            boolean noRunningTest;
            finishedTests.add(testName);
            boolean bl = noRunningTest = runningTests.size() <= finishedTests.size();
            if (!noRunningTest && System.nanoTime() - lastUpdate < TimeUnit.SECONDS.toNanos(1L)) {
                return;
            }
            lastUpdate = System.nanoTime();
            ArrayList<String> availableOwners = new ArrayList<String>(runningTests);
            runningTests.removeAll(finishedTests);
            finishedTests.clear();
            ThreadLeakChecker.updateThreadOwnership(availableOwners);
        }
        finally {
            lock.unlock();
        }
    }

    private static void updateThreadOwnership(List<String> availableOwners) {
        Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
        runningThreads.keySet().retainAll(currentThreads);
        for (Thread thread : currentThreads) {
            runningThreads.putIfAbsent(thread, new LeakInfo(thread, availableOwners));
        }
    }

    public static void checkForLeaks() {
        if (!ENABLED) {
            return;
        }
        lock.lock();
        try {
            assert (runningTests.isEmpty()) : "Tests are still running: " + runningTests;
            ThreadLeakChecker.performCheck();
        }
        finally {
            lock.unlock();
        }
    }

    private static void performCheck() {
        ThreadLeakChecker.updateThreadOwnership(Collections.singletonList("UNKNOWN"));
        List<LeakInfo> leaks = ThreadLeakChecker.computeLeaks();
        if (!leaks.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ThreadLeakChecker.updateThreadOwnership(Collections.singletonList("UNKNOWN"));
            leaks = ThreadLeakChecker.computeLeaks();
        }
        if (!leaks.isEmpty()) {
            for (LeakInfo leakInfo : leaks) {
                log.warnf("Possible leaked thread:\n%s", (Object)ThreadLeakChecker.prettyPrintStacktrace(leakInfo.thread));
                leakInfo.markReported();
            }
            throw new RuntimeException("Leaked threads: \n  " + leaks.stream().map(Object::toString).collect(Collectors.joining(",\n  ")));
        }
    }

    private static List<LeakInfo> computeLeaks() {
        ArrayList<LeakInfo> leaks = new ArrayList<LeakInfo>();
        for (LeakInfo leakInfo : runningThreads.values()) {
            if (!leakInfo.shouldReport() || !leakInfo.thread.isAlive() || ThreadLeakChecker.ignore(leakInfo.thread)) continue;
            leaks.add(leakInfo);
        }
        return leaks;
    }

    private static boolean ignore(Thread thread) {
        String threadName = thread.getName();
        if (IGNORED_THREADS_REGEX.matcher(threadName).matches()) {
            return true;
        }
        if (thread.getName().startsWith("Thread-")) {
            StackTraceElement[] s;
            if (thread.getClass().getName().equals("org.jboss.byteman.agent.TransformListener")) {
                return true;
            }
            for (StackTraceElement ste : s = thread.getStackTrace()) {
                if (!ste.getClassName().equals(ARQUILLIAN_CONSOLE_CONSUMER)) continue;
                return true;
            }
        }
        return false;
    }

    private static String prettyPrintStacktrace(Thread thread) {
        StackTraceElement[] s;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\"%s\" %sprio=%d tid=0x%x nid=NA %s\n", thread.getName(), thread.isDaemon() ? "daemon " : "", thread.getPriority(), thread.getId(), thread.getState().toString().toLowerCase()));
        sb.append("   java.lang.Thread.State: ").append((Object)thread.getState()).append('\n');
        for (StackTraceElement ste : s = thread.getStackTrace()) {
            sb.append("\tat ").append(ste).append('\n');
        }
        return sb.toString();
    }

    private static Set<Thread> getThreadsSnapshot() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        int capacity = group.activeCount() * 2;
        Thread[] threadsArray;
        int count;
        while ((count = group.enumerate(threadsArray = new Thread[capacity], true)) >= capacity) {
            capacity = count * 2;
        }
        return Arrays.stream(threadsArray, 0, count).collect(Collectors.toSet());
    }

    public static void ignoreThreadsMatching(Predicate<Thread> filter) {
        Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
        for (Thread thread : currentThreads) {
            if (!filter.test(thread)) continue;
            ThreadLeakChecker.ignoreThread(thread);
        }
    }

    public static void ignoreThread(Thread thread) {
        LeakInfo leakInfo = runningThreads.computeIfAbsent(thread, k -> new LeakInfo(thread, Collections.emptyList()));
        leakInfo.ignore();
    }

    public static void ignoreThreadsContaining(String threadNameRegex) {
        Pattern pattern = Pattern.compile(".*" + threadNameRegex + ".*");
        ThreadLeakChecker.ignoreThreadsMatching(thread -> pattern.matcher(thread.getName()).matches());
    }

    private static class LeakInfo {
        final Thread thread;
        final List<String> potentialOwnerTests;
        boolean reported;
        boolean ignored;

        LeakInfo(Thread thread, List<String> potentialOwnerTests) {
            this.thread = thread;
            this.potentialOwnerTests = potentialOwnerTests;
        }

        void ignore() {
            this.ignored = true;
        }

        void markReported() {
            this.reported = true;
        }

        boolean shouldReport() {
            return !this.ignored && !this.reported;
        }

        public String toString() {
            if (this.ignored) {
                return "{" + this.thread.getName() + ": ignored}";
            }
            String reportedString = this.reported ? " reported, " : "";
            return "{" + this.thread.getName() + ": " + reportedString + "possible sources " + this.potentialOwnerTests + "}";
        }
    }
}

