/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.api;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;

public enum CounterState {
    VALID,
    LOWER_BOUND_REACHED,
    UPPER_BOUND_REACHED;

    private static final CounterState[] CACHED_VALUES;
    public static final AdvancedExternalizer<CounterState> EXTERNALIZER;

    public static CounterState valueOf(int index) {
        return CACHED_VALUES[index];
    }

    static {
        CACHED_VALUES = CounterState.values();
        EXTERNALIZER = new Externalizer();
    }

    private static class Externalizer
    implements AdvancedExternalizer<CounterState> {
        private Externalizer() {
        }

        @Override
        public Set<Class<? extends CounterState>> getTypeClasses() {
            return Collections.singleton(CounterState.class);
        }

        @Override
        public Integer getId() {
            return 2001;
        }

        @Override
        public void writeObject(ObjectOutput output, CounterState object) throws IOException {
            MarshallUtil.marshallEnum(object, output);
        }

        @Override
        public CounterState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return MarshallUtil.unmarshallEnum(input, CounterState::valueOf);
        }
    }
}

