/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public abstract class AttributeSerializer<T, U extends ConfigurationInfo, B extends ConfigurationBuilderInfo> {
    public boolean canRead(String enclosing, String nestingName, String nestedName, AttributeDefinition attributeDefinition) {
        return nestingName == null && nestedName != null && nestedName.equals(attributeDefinition.xmlName());
    }

    public String getParentElement(U configurationElement) {
        return "";
    }

    public String getSerializationName(Attribute<T> attribute, U configurationElement) {
        return attribute.getAttributeDefinition().xmlName();
    }

    public Object getSerializationValue(Attribute<T> attribute, U configurationElement) {
        return attribute.get();
    }

    public Object readAttributeValue(String enclosingElement, AttributeDefinition attributeDefinition, Object attrValue, B builderInfo) {
        if (attrValue == null) {
            return null;
        }
        Class type = attributeDefinition.getType();
        if (attrValue instanceof Map && type == TypedProperties.class) {
            TypedProperties typedProperties = new TypedProperties();
            typedProperties.putAll((Map<?, ?>)((Map)attrValue));
            return typedProperties;
        }
        if (type.isEnum() && !attrValue.getClass().isEnum()) {
            return Enum.valueOf(type, attrValue.toString());
        }
        if (type == Set.class) {
            if (attrValue instanceof Collection) {
                return new HashSet((Collection)attrValue);
            }
        } else {
            if (type == Integer.class && attrValue instanceof Number) {
                return ((Number)attrValue).intValue();
            }
            if (type == Class.class) {
                return Util.loadClass(attrValue.toString(), builderInfo.getClass().getClassLoader());
            }
        }
        return attrValue;
    }
}

