/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;

public class ProtoStreamMarshaller
extends AbstractMarshaller {
    protected final SerializationContext serializationContext;

    public ProtoStreamMarshaller() {
        this(ProtobufUtil.newSerializationContext());
    }

    public ProtoStreamMarshaller(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.getSerializationContext(), (byte[])buf, (int)offset, (int)length);
    }

    @Override
    public boolean isMarshallable(Object o) {
        return o instanceof String || o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof byte[] || o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Date || o instanceof Instant || this.getSerializationContext().canMarshall(o.getClass());
    }

    @Override
    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException, InterruptedException {
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.getSerializationContext(), (Object)o);
        return new ByteBufferImpl(bytes, 0, bytes.length);
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }
}

