/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.PrimitiveIterator;
import java.util.Set;
import org.infinispan.commons.util.ConcurrentSmallIntSet;
import org.infinispan.commons.util.EmptyIntSet;
import org.infinispan.commons.util.ImmutableIntSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SingletonIntSet;
import org.infinispan.commons.util.SmallIntSet;

public class IntSets {
    private IntSets() {
    }

    public static IntSet immutableEmptySet() {
        return EmptyIntSet.getInstance();
    }

    public static IntSet immutableSet(int value) {
        return new SingletonIntSet(value);
    }

    public static IntSet immutableSet(IntSet set) {
        return new ImmutableIntSet(set);
    }

    public static IntSet immutableRangeSet(int endExclusive) {
        return new RangeSet(endExclusive);
    }

    public static IntSet from(Set<Integer> integerSet) {
        if (integerSet instanceof IntSet) {
            return (IntSet)integerSet;
        }
        int size = integerSet.size();
        switch (size) {
            case 0: {
                return EmptyIntSet.getInstance();
            }
            case 1: {
                return new SingletonIntSet(integerSet.iterator().next());
            }
        }
        return SmallIntSet.from(integerSet);
    }

    public static IntSet from(byte[] bytes) {
        int size = bytes.length;
        if (size == 0) {
            return EmptyIntSet.getInstance();
        }
        return SmallIntSet.from(bytes);
    }

    public static IntSet from(PrimitiveIterator.OfInt iterator) {
        boolean hasNext = iterator.hasNext();
        if (!hasNext) {
            return EmptyIntSet.getInstance();
        }
        int firstValue = iterator.nextInt();
        hasNext = iterator.hasNext();
        if (!hasNext) {
            return new SingletonIntSet(firstValue);
        }
        SmallIntSet set = new SmallIntSet();
        set.set(firstValue);
        iterator.forEachRemaining(set::set);
        return set;
    }

    public static IntSet mutableFrom(Set<Integer> integerSet) {
        if (integerSet instanceof SmallIntSet) {
            return (SmallIntSet)integerSet;
        }
        if (integerSet instanceof ConcurrentSmallIntSet) {
            return (ConcurrentSmallIntSet)integerSet;
        }
        return IntSets.mutableCopyFrom(integerSet);
    }

    public static IntSet mutableCopyFrom(Set<Integer> mutableSet) {
        if (mutableSet instanceof SingletonIntSet) {
            return IntSets.mutableSet(((SingletonIntSet)mutableSet).value);
        }
        return new SmallIntSet(mutableSet);
    }

    public static IntSet mutableEmptySet(int maxExclusive) {
        return new SmallIntSet(maxExclusive);
    }

    public static IntSet mutableEmptySet() {
        return new SmallIntSet();
    }

    public static IntSet mutableSet(int value) {
        return SmallIntSet.of(value);
    }

    public static IntSet mutableSet(int value1, int value2) {
        return SmallIntSet.of(value1, value2);
    }

    public static IntSet concurrentSet(int maxExclusive) {
        return new ConcurrentSmallIntSet(maxExclusive);
    }

    public static IntSet concurrentCopyFrom(IntSet intSet, int maxExclusive) {
        ConcurrentSmallIntSet cis = new ConcurrentSmallIntSet(maxExclusive);
        intSet.forEach(cis::set);
        return cis;
    }
}

