/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.time;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.DefaultTimeService;

public class ControlledTimeService
extends DefaultTimeService {
    protected volatile long currentMillis;

    public ControlledTimeService() {
        this(System.currentTimeMillis());
    }

    public ControlledTimeService(long currentMillis) {
        this.currentMillis = currentMillis;
    }

    public long wallClockTime() {
        return this.currentMillis;
    }

    public long time() {
        return TimeUnit.MILLISECONDS.toNanos(this.currentMillis);
    }

    public Instant instant() {
        return Instant.ofEpochMilli(this.currentMillis);
    }

    public synchronized void advance(long time) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Argument must be greater than 0");
        }
        this.currentMillis += time;
    }
}

