/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class XidUnitTest {
    private static final Log log = LogFactory.getLog(XidUnitTest.class);

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidGlobalTransaction() {
        long seed = System.currentTimeMillis();
        log.infof("[testInvalidGlobalTransaction] seed: %s", (Object)seed);
        Random random = new Random(seed);
        XidImpl xid = XidImpl.create((int)random.nextInt(), (byte[])Util.EMPTY_BYTE_ARRAY, (byte[])new byte[]{0});
        log.debugf("Invalid XID: %s", (Object)xid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidGlobalTransaction2() {
        long seed = System.currentTimeMillis();
        log.infof("[testInvalidGlobalTransaction2] seed: %s", (Object)seed);
        Random random = new Random(seed);
        byte[] globalTx = new byte[65];
        random.nextBytes(globalTx);
        XidImpl xid = XidImpl.create((int)random.nextInt(), (byte[])globalTx, (byte[])new byte[]{0});
        log.debugf("Invalid XID: %s", (Object)xid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBranch() {
        long seed = System.currentTimeMillis();
        log.infof("[testInvalidBranch] seed: %s", (Object)seed);
        Random random = new Random(seed);
        XidImpl xid = XidImpl.create((int)random.nextInt(), (byte[])new byte[]{0}, (byte[])Util.EMPTY_BYTE_ARRAY);
        log.debugf("Invalid XID: %s", (Object)xid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBranch2() {
        long seed = System.currentTimeMillis();
        log.infof("[testInvalidBranch2] seed: %s", (Object)seed);
        Random random = new Random(seed);
        byte[] branch = new byte[65];
        random.nextBytes(branch);
        XidImpl xid = XidImpl.create((int)random.nextInt(), (byte[])new byte[]{0}, (byte[])branch);
        log.debugf("Invalid XID: %s", (Object)xid);
    }

    @Test
    public void testCorrectDataStored() {
        long seed = System.currentTimeMillis();
        log.infof("[testCorrectDataStored] seed: %s", (Object)seed);
        Random random = new Random(seed);
        int formatId = random.nextInt();
        byte[] tx = new byte[random.nextInt(64) + 1];
        byte[] branch = new byte[random.nextInt(64) + 1];
        random.nextBytes(tx);
        random.nextBytes(branch);
        XidImpl xid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("XID: %s", (Object)xid);
        Assert.assertEquals((long)formatId, (long)xid.getFormatId());
        Assert.assertArrayEquals((byte[])tx, (byte[])xid.getGlobalTransactionId());
        Assert.assertArrayEquals((byte[])branch, (byte[])xid.getBranchQualifier());
        XidImpl sameXid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("same XID: %s", (Object)sameXid);
        Assert.assertEquals((Object)xid, (Object)sameXid);
    }

    @Test
    public void testCorrectDataStoredMaxSize() {
        long seed = System.currentTimeMillis();
        log.infof("[testCorrectDataStoredMaxSize] seed: %s", (Object)seed);
        Random random = new Random(seed);
        int formatId = random.nextInt();
        byte[] tx = new byte[64];
        byte[] branch = new byte[64];
        random.nextBytes(tx);
        random.nextBytes(branch);
        XidImpl xid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("XID: %s", (Object)xid);
        Assert.assertEquals((long)formatId, (long)xid.getFormatId());
        Assert.assertArrayEquals((byte[])tx, (byte[])xid.getGlobalTransactionId());
        Assert.assertArrayEquals((byte[])branch, (byte[])xid.getBranchQualifier());
        XidImpl sameXid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("same XID: %s", (Object)sameXid);
        Assert.assertEquals((Object)xid, (Object)sameXid);
    }

    @Test
    public void testMarshalling() throws IOException, ClassNotFoundException {
        long seed = System.currentTimeMillis();
        log.infof("[testMarshalling] seed: %s", (Object)seed);
        Random random = new Random(seed);
        int formatId = random.nextInt();
        byte[] tx = new byte[random.nextInt(64) + 1];
        byte[] branch = new byte[random.nextInt(64) + 1];
        random.nextBytes(tx);
        random.nextBytes(branch);
        XidImpl xid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("XID: %s", (Object)xid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        ObjectOutputStream oo = new ObjectOutputStream(bos);
        XidImpl.writeTo((ObjectOutput)oo, (XidImpl)xid);
        oo.flush();
        oo.close();
        bos.close();
        byte[] marshalled = bos.toByteArray();
        log.debugf("Size: %s", marshalled.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(marshalled);
        ObjectInputStream oi = new ObjectInputStream(bis);
        XidImpl otherXid = XidImpl.readFrom((ObjectInput)oi);
        oi.close();
        bis.close();
        log.debugf("other XID: %s", (Object)xid);
        Assert.assertEquals((Object)xid, (Object)otherXid);
    }

    @Test
    public void testMarshallingMaxSize() throws IOException, ClassNotFoundException {
        long seed = System.currentTimeMillis();
        log.infof("[testMarshallingMaxSize] seed: %s", (Object)seed);
        Random random = new Random(seed);
        int formatId = random.nextInt();
        byte[] tx = new byte[64];
        byte[] branch = new byte[64];
        random.nextBytes(tx);
        random.nextBytes(branch);
        XidImpl xid = XidImpl.create((int)formatId, (byte[])tx, (byte[])branch);
        log.debugf("XID: %s", (Object)xid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        ObjectOutputStream oo = new ObjectOutputStream(bos);
        XidImpl.writeTo((ObjectOutput)oo, (XidImpl)xid);
        oo.flush();
        oo.close();
        bos.close();
        byte[] marshalled = bos.toByteArray();
        log.debugf("Size: %s", marshalled.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(marshalled);
        ObjectInputStream oi = new ObjectInputStream(bis);
        XidImpl otherXid = XidImpl.readFrom((ObjectInput)oi);
        oi.close();
        bis.close();
        log.debugf("other XID: %s", (Object)xid);
        Assert.assertEquals((Object)xid, (Object)otherXid);
    }
}

