/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.junit.Assert;
import org.junit.Test;

public class TypedPropertiesTest {
    @Test
    public void testIntProperty() {
        TypedProperties p = this.createProperties();
        Assert.assertEquals((long)1L, (long)p.getIntProperty("int", 999));
        Assert.assertEquals((long)10L, (long)p.getIntProperty("int_put_str", 999));
        Assert.assertEquals((long)1L, (long)p.getIntProperty("int_invalid", 1));
        Assert.assertEquals((long)1L, (long)p.getIntProperty("int_null", 1));
        System.setProperty("fooVar", "100");
        Assert.assertEquals((long)100L, (long)p.getIntProperty("int_key_value_replacement", 1, true));
        System.clearProperty("fooVar");
    }

    @Test
    public void testLongProperty() {
        TypedProperties p = this.createProperties();
        Assert.assertEquals((long)2L, (long)p.getLongProperty("long", 999L));
        Assert.assertEquals((long)20L, (long)p.getLongProperty("long_put_str", 999L));
        Assert.assertEquals((long)2L, (long)p.getLongProperty("long_invalid", 2L));
        Assert.assertEquals((long)2L, (long)p.getLongProperty("long_null", 2L));
    }

    @Test
    public void testBooleanProperty() {
        TypedProperties p = this.createProperties();
        Assert.assertEquals((Object)true, (Object)p.getBooleanProperty("boolean", false));
        Assert.assertEquals((Object)true, (Object)p.getBooleanProperty("boolean_put_str", false));
        Assert.assertEquals((Object)true, (Object)p.getBooleanProperty("boolean_invalid", true));
        Assert.assertEquals((Object)true, (Object)p.getBooleanProperty("boolean_null", true));
    }

    @Test
    public void testEnumProperty() {
        TypedProperties p = this.createProperties();
        Assert.assertEquals((Object)((Object)COLOR.BLUE), (Object)p.getEnumProperty("enum_cast", COLOR.class, (Enum)COLOR.BLUE));
        Assert.assertEquals((Object)((Object)COLOR.RED), (Object)p.getEnumProperty("enum", COLOR.class, (Enum)COLOR.BLUE));
        Assert.assertEquals((Object)((Object)COLOR.RED), (Object)p.getEnumProperty("enum_put_str", COLOR.class, (Enum)COLOR.BLUE));
        Assert.assertEquals((Object)((Object)COLOR.BLUE), (Object)p.getEnumProperty("enum_invalid", COLOR.class, (Enum)COLOR.BLUE));
        Assert.assertEquals((Object)((Object)COLOR.BLUE), (Object)p.getEnumProperty("enum_null", COLOR.class, (Enum)COLOR.BLUE));
        Assert.assertEquals((Object)((Object)COLOR.BLUE), (Object)p.getEnumProperty("enum_other", COLOR.class, (Enum)COLOR.BLUE));
    }

    private TypedProperties createProperties() {
        Properties p = new Properties();
        p.put("int", (Object)1);
        p.put("int_put_str", Integer.toString(10));
        p.put("int_invalid", (Object)false);
        p.put("int_key_value_replacement", "${fooVar}");
        p.put("long", (Object)2L);
        p.put("long_put_str", Long.toString(20L));
        p.put("long_invalid", (Object)false);
        p.put("boolean", (Object)true);
        p.put("boolean_put_str", Boolean.toString(true));
        p.put("boolean_invalid", (Object)COLOR.RED);
        p.put("enum", (Object)COLOR.RED);
        p.put("enum_put_str", COLOR.RED.toString());
        p.put("enum_invalid", (Object)false);
        p.put("enum_other", (Object)NUMBER.NUMBER_1);
        return new TypedProperties(p);
    }

    private static enum NUMBER {
        NUMBER_1;

    }

    private static enum COLOR {
        RED,
        BLUE;

    }
}

