/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.LazyByteArrayOutputStream;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.Marshaller;

public abstract class AbstractMarshaller
implements Marshaller {
    protected final MarshallableTypeHints marshallableTypeHints = new MarshallableTypeHints();

    @Override
    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshallableTypeHints.getBufferSizePredictor(o.getClass());
    }

    protected abstract ByteBuffer objectToBuffer(Object var1, int var2) throws IOException, InterruptedException;

    @Override
    public ByteBuffer objectToBuffer(Object obj) throws IOException, InterruptedException {
        if (obj != null) {
            ByteBuffer byteBuffer;
            int length;
            BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor(obj.getClass());
            int estimatedSize = sizePredictor.nextSize(obj);
            if (estimatedSize > (length = (byteBuffer = this.objectToBuffer(obj, estimatedSize)).getLength()) * 4) {
                byte[] buffer = this.trimBuffer(byteBuffer);
                byteBuffer = ByteBufferImpl.create(buffer);
            }
            sizePredictor.recordSize(length);
            return byteBuffer;
        }
        return this.objectToBuffer(null, 1);
    }

    @Override
    public byte[] objectToByteBuffer(Object o) throws IOException, InterruptedException {
        if (o != null) {
            BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor(o.getClass());
            byte[] bytes = this.objectToByteBuffer(o, sizePredictor.nextSize(o));
            sizePredictor.recordSize(bytes.length);
            return bytes;
        }
        return this.objectToByteBuffer(null, 1);
    }

    @Override
    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ByteBuffer b = this.objectToBuffer(obj, estimatedSize);
        return this.trimBuffer(b);
    }

    private byte[] trimBuffer(ByteBuffer b) {
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    public Object objectFromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        int bytesRead;
        byte[] buf;
        LazyByteArrayOutputStream bytes;
        int len = inputStream.available();
        if (len > 0) {
            bytes = new LazyByteArrayOutputStream(len);
            buf = new byte[Math.min(len, 1024)];
        } else {
            bytes = new LazyByteArrayOutputStream();
            buf = new byte[1024];
        }
        while ((bytesRead = inputStream.read(buf, 0, buf.length)) != -1) {
            bytes.write(buf, 0, bytesRead);
        }
        return this.objectFromByteBuffer(bytes.getRawBuffer(), 0, bytes.size());
    }

    public void objectToOutputStream(Object obj, OutputStream outputStream) throws IOException, InterruptedException {
        byte[] bytes = this.objectToByteBuffer(obj);
        outputStream.write(bytes);
    }
}

