/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.Base16Codec;
import org.infinispan.commons.dataconversion.BinaryTranscoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.RFC4648Codec;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.KeyValueWithPrevious;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BinaryTranscoderTest {
    private static BinaryTranscoder binaryTranscoder;
    private static JavaSerializationMarshaller marshaller;

    @BeforeClass
    public static void prepare() {
        ClassAllowList allowList = new ClassAllowList();
        allowList.addRegexps(new String[]{".*"});
        marshaller = new JavaSerializationMarshaller(allowList);
        binaryTranscoder = new BinaryTranscoder((Marshaller)marshaller);
    }

    @Test
    public void testToFromUnknown() {
        this.testWithContentTypes(MediaType.APPLICATION_UNKNOWN, MediaType.APPLICATION_UNKNOWN);
    }

    @Test
    public void testToFromOctetStream() {
        this.testWithContentTypes(MediaType.APPLICATION_UNKNOWN, MediaType.APPLICATION_OCTET_STREAM);
        this.testWithContentTypes(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_UNKNOWN);
    }

    @Test
    public void testToFromTextPlain() {
        this.testWithContentTypes(MediaType.APPLICATION_UNKNOWN, MediaType.TEXT_PLAIN);
        this.testWithContentTypes(MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN);
    }

    @Test
    public void testToFromUrlEncoded() throws Exception {
        String data = "word1 word2";
        byte[] dataBinary = data.getBytes(StandardCharsets.UTF_8);
        String encoded = URLEncoder.encode(data, "utf-8");
        byte[] dataEncoded = encoded.getBytes(StandardCharsets.UTF_8);
        Object toBinary = binaryTranscoder.transcode((Object)dataEncoded, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.APPLICATION_UNKNOWN);
        Object toBinaryHex = binaryTranscoder.transcode((Object)dataEncoded, MediaType.APPLICATION_WWW_FORM_URLENCODED, this.hexEncoded(MediaType.APPLICATION_UNKNOWN));
        Object toBinaryBase64 = binaryTranscoder.transcode((Object)dataEncoded, MediaType.APPLICATION_WWW_FORM_URLENCODED, this.base64Encoded(MediaType.APPLICATION_UNKNOWN));
        Assert.assertArrayEquals((byte[])dataBinary, (byte[])((byte[])toBinary));
        Assert.assertEquals((Object)Base16Codec.encode((byte[])dataBinary), (Object)toBinaryHex);
        this.assertSame(Base64.getEncoder().encode(dataBinary), toBinaryBase64);
        Object fromBinary = binaryTranscoder.transcode(toBinary, MediaType.APPLICATION_UNKNOWN, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        Object fromBinaryHex = binaryTranscoder.transcode(toBinaryHex, this.hexEncoded(MediaType.APPLICATION_UNKNOWN), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        Object fromBinaryBase64 = binaryTranscoder.transcode(toBinaryBase64, this.base64Encoded(MediaType.APPLICATION_UNKNOWN), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        this.assertSame(dataEncoded, fromBinary);
        this.assertSame(dataEncoded, fromBinaryHex);
        this.assertSame(dataEncoded, fromBinaryBase64);
    }

    @Test
    public void testToFromObject() throws Exception {
        this.testToFromObject("string-data");
        this.testToFromObject(new KeyValueWithPrevious((Object)"string", (Object)1L, (Object)0L));
        this.testToFromObject(new byte[]{1, 2, 3});
    }

    private void testToFromObject(Object data) throws Exception {
        byte[] binaryForm = marshaller.objectToByteBuffer(data);
        Object toBinary = binaryTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_UNKNOWN);
        Object toBinaryHex = binaryTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, this.hexEncoded(MediaType.APPLICATION_UNKNOWN));
        Object toBinaryBase64 = binaryTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, this.base64Encoded(MediaType.APPLICATION_UNKNOWN));
        Assert.assertArrayEquals((byte[])binaryForm, (byte[])((byte[])toBinary));
        Assert.assertEquals((Object)Base16Codec.encode((byte[])binaryForm), (Object)toBinaryHex);
        this.assertSame(Base64.getEncoder().encode(binaryForm), toBinaryBase64);
        Object fromBinary = binaryTranscoder.transcode(toBinary, MediaType.APPLICATION_UNKNOWN, MediaType.APPLICATION_OBJECT);
        Object fromBinaryHex = binaryTranscoder.transcode(toBinaryHex, this.hexEncoded(MediaType.APPLICATION_UNKNOWN), MediaType.APPLICATION_OBJECT);
        Object fromBinaryBase64 = binaryTranscoder.transcode(toBinaryBase64, this.base64Encoded(MediaType.APPLICATION_UNKNOWN), MediaType.APPLICATION_OBJECT);
        this.assertSame(data, fromBinary);
        this.assertSame(data, fromBinaryHex);
        this.assertSame(data, fromBinaryBase64);
    }

    private void assertSame(Object expected, Object obtained) {
        if (expected instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])obtained));
        } else {
            Assert.assertEquals((Object)expected, (Object)obtained);
        }
    }

    private void testWithContentTypes(MediaType sourceType, MediaType targetType) {
        byte[] data = new byte[]{1, 2, 3};
        MediaType[] sourceTypes = new MediaType[]{sourceType, this.hexEncoded(sourceType), this.base64Encoded(sourceType)};
        MediaType[] targetTypes = new MediaType[]{targetType, this.hexEncoded(targetType), this.base64Encoded(targetType)};
        for (MediaType source : sourceTypes) {
            for (MediaType target : targetTypes) {
                Object dataIn = this.encodeIfNeeded(data, source);
                Object expected = this.encodeIfNeeded(data, target);
                Object result = binaryTranscoder.transcode(dataIn, source, target);
                this.assertSame(expected, result);
            }
        }
    }

    private MediaType hexEncoded(MediaType mediaType) {
        return mediaType.withParameter("encoding", "hex");
    }

    private MediaType base64Encoded(MediaType mediaType) {
        return mediaType.withParameter("encoding", "base64");
    }

    private Object encodeIfNeeded(Object data, MediaType type) {
        String encoding = type.getEncoding();
        if (encoding == null || !(data instanceof byte[])) {
            return data;
        }
        return new RFC4648Codec().encodeContent(data, type);
    }
}

