/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.time.Instant;
import javax.security.auth.x500.X500Principal;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.util.ReloadingX509KeyManager;
import org.infinispan.commons.util.ReloadingX509TrustManager;
import org.infinispan.commons.util.SslContextFactory;
import org.junit.Test;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

public class SslContextFactoryTest {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String SECRET = "secret";

    @Test
    public void testSslContextFactoryWatch() throws IOException {
        try (FileWatcher watcher = new FileWatcher();){
            Path tmpDir = Paths.get(CommonsTestingUtil.tmpDirectory(SslContextFactoryTest.class), new String[0]);
            Files.createDirectories(tmpDir, new FileAttribute[0]);
            Path keystore = this.createCertificateKeyStore("keystore", SECRET, tmpDir);
            Path truststore = this.createCertificateKeyStore("truststore", SECRET, tmpDir);
            SslContextFactory.Context context = new SslContextFactory().keyStoreFileName(keystore.toString()).keyStorePassword(SECRET.toCharArray()).trustStoreFileName(truststore.toString()).trustStorePassword(SECRET.toCharArray()).watcher(watcher).build();
            context.sslContext().createSSLEngine();
            Instant kmLastLoaded = ((ReloadingX509KeyManager)context.keyManager()).lastLoaded();
            this.createCertificateKeyStore("keystore", SECRET, tmpDir);
            Eventually.eventually(() -> ((ReloadingX509KeyManager)context.keyManager()).lastLoaded().isAfter(kmLastLoaded));
            Instant tmlastLoaded = ((ReloadingX509TrustManager)context.trustManager()).lastLoaded();
            this.createCertificateKeyStore("truststore", SECRET, tmpDir);
            Eventually.eventually(() -> ((ReloadingX509TrustManager)context.trustManager()).lastLoaded().isAfter(tmlastLoaded));
            context.sslContext().createSSLEngine();
        }
    }

    private Path createCertificateKeyStore(String name, String secret, Path dir) {
        Path path;
        block8: {
            SelfSignedX509CertificateAndSigningKey.Builder certificateBuilder = SelfSignedX509CertificateAndSigningKey.builder().setDn(new X500Principal("CN=" + name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM);
            SelfSignedX509CertificateAndSigningKey certificate = certificateBuilder.build();
            Path file = dir.resolve(name + ".pfx");
            OutputStream os = Files.newOutputStream(file, new OpenOption[0]);
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry(name, certificate.getSelfSignedCertificate());
                keyStore.store(os, secret.toCharArray());
                path = file;
                if (os == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            os.close();
        }
        return path;
    }
}

