/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.util.Immutables;

@Immutable
public class ImmutableListCopy<E>
extends AbstractList<E>
implements Immutables.Immutable {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private final Object[] elements;

    public ImmutableListCopy() {
        this.elements = EMPTY_ARRAY;
    }

    public ImmutableListCopy(Collection<? extends E> c) {
        this.elements = c instanceof ImmutableListCopy ? ((ImmutableListCopy)c).elements : c.toArray();
    }

    public ImmutableListCopy(E[] array) {
        this.elements = array;
    }

    public ImmutableListCopy(Collection<? extends E> collection1, Collection<? extends E> collection2) {
        if (collection2.isEmpty()) {
            this.elements = collection1 instanceof ImmutableListCopy ? ((ImmutableListCopy)collection1).elements : collection1.toArray();
        } else if (collection1.isEmpty()) {
            this.elements = collection2 instanceof ImmutableListCopy ? ((ImmutableListCopy)collection2).elements : collection2.toArray();
        } else {
            int c1Size = collection1.size();
            int c2Size = collection2.size();
            int size = c1Size + c2Size;
            this.elements = new Object[size];
            collection1.toArray(this.elements);
            Object[] c2 = collection2.toArray();
            System.arraycopy(c2, 0, this.elements, c1Size, c2Size);
        }
    }

    @Override
    public final int size() {
        return this.elements.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public final Iterator<E> iterator() {
        return new ImmutableIterator();
    }

    @Override
    public final Object[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        int size = this.elements.length;
        if (a.length < size) {
            return Arrays.copyOf(this.elements, size, a.getClass());
        }
        System.arraycopy(this.elements, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public final boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public final int indexOf(Object o) {
        int size = this.elements.length;
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object o) {
        int size = this.elements.length;
        if (o == null) {
            for (int i = size - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new ImmutableIterator();
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        return new ImmutableIterator(index);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        return new ImmutableSubList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableListCopy)) {
            return super.equals(o);
        }
        ImmutableListCopy that = (ImmutableListCopy)o;
        return Arrays.equals(this.elements, that.elements);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    private class ImmutableIterator
    implements ListIterator<E> {
        int cursor = 0;

        ImmutableIterator(int index) {
            if (index < 0 || index > ImmutableListCopy.this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            this.cursor = index;
        }

        ImmutableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableListCopy.this.elements.length;
        }

        @Override
        public E next() {
            try {
                return ImmutableListCopy.this.get(this.cursor++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                return ImmutableListCopy.this.get(--this.cursor);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }

    public class ImmutableSubList
    extends AbstractList<E> {
        private final int offset;
        private final int size;

        ImmutableSubList(int fromIndex, int toIndex) {
            int size = ImmutableListCopy.this.elements.length;
            if (fromIndex < 0 || toIndex > size || fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + "), toIndex(" + toIndex + "), size (" + size + "), List=" + ImmutableListCopy.this.toString());
            }
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public final E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return ImmutableListCopy.this.get(index + this.offset);
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        protected final void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<E> iterator() {
            return super.listIterator();
        }

        @Override
        public final ListIterator<E> listIterator(final int index) {
            if (index < 0 || index != 0 && index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return new ListIterator<E>(){
                private final ListIterator<?> i;
                final /* synthetic */ ImmutableSubList this$1;
                {
                    this.this$1 = this$1;
                    this.i = this.this$1.ImmutableListCopy.this.listIterator(index + this.this$1.offset);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < this.this$1.size;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        return this.i.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public E previous() {
                    if (this.hasPrevious()) {
                        return this.i.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - this.this$1.offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - this.this$1.offset;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final List<E> subList(int fromIndex, int toIndex) {
            return new ImmutableSubList(this.offset + fromIndex, this.offset + toIndex);
        }
    }
}

