/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import org.infinispan.commons.util.Util;

@ThreadSafe
public class FileSystemLock {
    private final Path directory;
    private final String name;
    @GuardedBy(value="this")
    private FileOutputStream globalLockFile;
    @GuardedBy(value="this")
    private FileLock globalLock;

    public FileSystemLock(Path directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public synchronized boolean tryLock() throws IOException {
        File lockFile = this.getLockFile();
        return this.acquireGlobalLock(lockFile);
    }

    public synchronized void unlock() {
        if (this.globalLockFile != null) {
            if (this.globalLock != null && this.globalLock.isValid()) {
                Util.close((AutoCloseable)this.globalLock);
            }
            this.globalLock = null;
            Util.close((AutoCloseable)this.globalLockFile);
            this.getLockFile().delete();
        }
    }

    public synchronized void unsafeLock() throws IOException {
        boolean retry;
        do {
            this.getLockFile().delete();
        } while (retry = !this.tryLock());
    }

    public synchronized boolean isAcquired() {
        return this.globalLock != null && this.globalLock.isValid();
    }

    private File getLockFile() {
        return this.directory.resolve(this.lockFileName()).toFile();
    }

    private boolean acquireGlobalLock(File lockFile) throws IOException {
        assert (Thread.holdsLock(this));
        lockFile.getParentFile().mkdirs();
        this.globalLockFile = new FileOutputStream(lockFile);
        try {
            this.globalLock = this.globalLockFile.getChannel().tryLock();
            return this.globalLock.isValid();
        }
        catch (OverlappingFileLockException ignore) {
            return false;
        }
    }

    private String lockFileName() {
        return String.format("%s.lck", this.name);
    }

    public String toString() {
        return "FileSystemLock{directory=" + String.valueOf(this.directory) + ", file=" + this.lockFileName() + "}";
    }
}

