/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.uberjar;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.uberjar.UberJarDuplicatedJarsWarner;

public class ManifestUberJarDuplicatedJarsWarner
implements UberJarDuplicatedJarsWarner {
    private static final Log logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String MANIFEST_LOCATION = "META-INF/MANIFEST.MF";
    private final String SYMBOLIC_NAME_MANIFEST_ENTRY = "Bundle-SymbolicName";

    @Override
    public boolean isClasspathCorrect() {
        List<String> bundleNames = this.getBundleSymbolicNames();
        long numberOfMatches = bundleNames.stream().filter(this.hasRemoteUberJar().or(this.hasEmbeddedUberJar()).or(this.hasCommons())).count();
        return numberOfMatches < 2L;
    }

    List<String> getBundleSymbolicNames() {
        ArrayList<String> symbolicNames = new ArrayList<String>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(MANIFEST_LOCATION);
            while (resources.hasMoreElements()) {
                URL manifestUrl = resources.nextElement();
                InputStream is = manifestUrl.openStream();
                try {
                    Manifest manifest = new Manifest(is);
                    symbolicNames.add(manifest.getMainAttributes().getValue("Bundle-SymbolicName"));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            logger.warn("Can not extract jar manifest from the classpath. Uber Jar classpath check is skipped.");
        }
        return symbolicNames;
    }

    Predicate<String> hasCommons() {
        return jarSymbolicName -> "org.infinispan.commons".equals(jarSymbolicName);
    }

    Predicate<String> hasEmbeddedUberJar() {
        return jarSymbolicName -> "org.infinispan.embedded".equals(jarSymbolicName);
    }

    Predicate<String> hasRemoteUberJar() {
        return jarSymbolicName -> "org.infinispan.remote".equals(jarSymbolicName);
    }

    @Override
    public CompletableFuture<Boolean> isClasspathCorrectAsync() {
        return CompletableFuture.supplyAsync(() -> this.isClasspathCorrect());
    }
}

