/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.equivalence;

import java.util.AbstractSet;
import java.util.Iterator;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentHashMap;

public class EquivalentHashSet<E>
extends AbstractSet<E> {
    private final Equivalence<? super E> entryEq;
    private final EquivalentHashMap<E, Boolean> m;

    public EquivalentHashSet(Equivalence<? super E> entryEq) {
        this.entryEq = entryEq;
        this.m = new EquivalentHashMap<E, Boolean>(entryEq, AnyEquivalence.BOOLEAN);
    }

    public EquivalentHashSet(int initialCapacity, Equivalence<? super E> entryEq) {
        this.entryEq = entryEq;
        this.m = new EquivalentHashMap<E, Boolean>(initialCapacity, entryEq, AnyEquivalence.BOOLEAN);
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.keySet().iterator();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.m.put(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) != null;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E obj : this) {
            if (obj == null) continue;
            h += this.entryEq.hashCode(obj);
        }
        return h;
    }
}

