/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;

public class InfinispanConfigurationParser {
    private final ParserRegistry configurationParser;
    private final ClassLoader ispnClassLoadr = InfinispanConfigurationParser.class.getClassLoader();

    public InfinispanConfigurationParser() {
        this.configurationParser = new ParserRegistry(this.ispnClassLoadr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename, String transportOverrideResource, ServiceManager serviceManager) throws IOException {
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceManager.requestService(ClassLoaderService.class);
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parseFile(classLoaderService, filename, transportOverrideResource);
            return configurationBuilderHolder;
        }
        finally {
            serviceManager.releaseService(ClassLoaderService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationBuilderHolder parseFile(ClassLoaderService classLoaderService, String filename, String transportOverrideResource) throws IOException {
        URL url = classLoaderService.locateResource(filename);
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.ispnClassLoadr);
            ConfigurationBuilderHolder builderHolder = this.configurationParser.parse(url);
            this.fixClassLoaders(builderHolder);
            this.patchTransportConfiguration(builderHolder, transportOverrideResource);
            ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
            return configurationBuilderHolder;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }

    private void fixClassLoaders(ConfigurationBuilderHolder builderHolder) {
        builderHolder.getGlobalConfigurationBuilder().classLoader(this.ispnClassLoadr);
    }

    private void patchTransportConfiguration(ConfigurationBuilderHolder builderHolder, String transportOverrideResource) throws IOException {
        if (transportOverrideResource != null) {
            try (InputStream xml = FileLookupFactory.newInstance().lookupFileStrict(transportOverrideResource, this.ispnClassLoadr);){
                Properties p = new Properties();
                FileJGroupsChannelConfigurator configurator = new FileJGroupsChannelConfigurator("override", transportOverrideResource, xml, System.getProperties());
                p.put("channelConfigurator", configurator);
                builderHolder.getGlobalConfigurationBuilder().transport().withProperties(p);
            }
        }
    }
}

