/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.SimpleJSAP;
import java.io.IOException;
import java.util.Iterator;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.demo.CacheBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

public abstract class Demo {
    protected final boolean isMaster;
    protected final String cfgFile;
    protected final JSAPResult commandLineOptions;

    public Demo(String[] args) throws Exception {
        this.commandLineOptions = this.parseParameters(args);
        String nodeType = this.commandLineOptions.getString("nodeType");
        this.isMaster = nodeType != null && nodeType.equals("master");
        this.cfgFile = this.commandLineOptions.getString("configFile");
    }

    protected JSAPResult parseParameters(String[] args) throws Exception {
        SimpleJSAP jsap = this.buildCommandLineOptions();
        JSAPResult config = jsap.parse(args);
        if (!config.success() || jsap.messagePrinted()) {
            Iterator messageIterator = config.getErrorMessageIterator();
            while (messageIterator.hasNext()) {
                System.err.println(messageIterator.next());
            }
            System.err.println(jsap.getHelp());
            return null;
        }
        return config;
    }

    protected Cache<String, String> startCache() throws IOException {
        CacheBuilder cb = new CacheBuilder(this.cfgFile);
        EmbeddedCacheManager cacheManager = cb.getCacheManager();
        Configuration cacheCfg = cacheManager.getDefaultConfiguration().clone().fluent().clustering().l1().disable().mode(Configuration.CacheMode.DIST_SYNC).hash().numOwners(Integer.valueOf(1)).build();
        cacheManager.defineConfiguration("wordcount", cacheCfg);
        Cache cache = cacheManager.getCache();
        Transport transport = cache.getAdvancedCache().getRpcManager().getTransport();
        if (this.isMaster) {
            System.out.printf("Node %s joined as master. View is %s.%n", transport.getAddress(), transport.getMembers());
        } else {
            System.out.printf("Node %s joined as slave. View is %s.%n", transport.getAddress(), transport.getMembers());
        }
        return cache;
    }

    protected abstract SimpleJSAP buildCommandLineOptions() throws JSAPException;
}

