/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.SimpleJSAP;
import java.io.IOException;
import java.util.Iterator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.demo.CacheBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

public abstract class Demo {
    protected final boolean isMaster;
    protected final String cfgFile;
    protected final JSAPResult commandLineOptions;

    public Demo(String[] args) throws Exception {
        this.commandLineOptions = this.parseParameters(args);
        String nodeType = this.commandLineOptions.getString("nodeType");
        this.isMaster = nodeType != null && nodeType.equals("master");
        this.cfgFile = this.commandLineOptions.getString("configFile");
    }

    protected JSAPResult parseParameters(String[] args) throws Exception {
        SimpleJSAP jsap = this.buildCommandLineOptions();
        JSAPResult config = jsap.parse(args);
        if (!config.success() || jsap.messagePrinted()) {
            Iterator messageIterator = config.getErrorMessageIterator();
            while (messageIterator.hasNext()) {
                System.err.println(messageIterator.next());
            }
            System.err.println(jsap.getHelp());
            return null;
        }
        return config;
    }

    protected Cache<String, String> startCache() throws IOException {
        CacheBuilder cb = new CacheBuilder(this.cfgFile);
        EmbeddedCacheManager cacheManager = cb.getCacheManager();
        Configuration dcc = cacheManager.getDefaultCacheConfiguration();
        cacheManager.defineConfiguration("wordcount", new ConfigurationBuilder().read(dcc).clustering().l1().disable().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(1).build());
        Cache cache = cacheManager.getCache();
        Transport transport = cache.getAdvancedCache().getRpcManager().getTransport();
        if (this.isMaster) {
            System.out.printf("Node %s joined as master. View is %s.%n", transport.getAddress(), transport.getMembers());
        } else {
            System.out.printf("Node %s joined as slave. View is %s.%n", transport.getAddress(), transport.getMembers());
        }
        return cache;
    }

    protected abstract SimpleJSAP buildCommandLineOptions() throws JSAPException;
}

