/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.mapreduce;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.Cache;
import org.infinispan.demo.Demo;
import org.infinispan.demo.mapreduce.WordCountCollator;
import org.infinispan.demo.mapreduce.WordCountMapper;
import org.infinispan.demo.mapreduce.WordCountReducer;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.util.Util;

public class WordCountDemo
extends Demo {
    private String textFile;
    private int numPopularWords;

    public static void main(String ... args) throws Exception {
        new WordCountDemo(args).run();
    }

    public WordCountDemo(String[] args) throws Exception {
        super(args);
        this.textFile = this.commandLineOptions.getString("textFile");
        this.numPopularWords = this.commandLineOptions.getInt("mostPopularWords");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        Cache<String, String> cache = this.startCache();
        if (this.textFile != null) {
            this.loadData(cache);
        }
        try {
            if (this.isMaster) {
                long start = System.currentTimeMillis();
                MapReduceTask mapReduceTask = new MapReduceTask(cache);
                List topList = (List)mapReduceTask.mappedWith((Mapper)new WordCountMapper()).reducedWith((Reducer)new WordCountReducer()).execute((Collator)new WordCountCollator(this.numPopularWords));
                System.out.printf(" ---- RESULTS: Top %s words in %s ---- %n%n", this.numPopularWords, this.textFile);
                int z = 0;
                for (Map.Entry e : topList) {
                    System.out.printf("  %s) %s [ %,d occurences ]%n", ++z, e.getKey(), e.getValue());
                }
                System.out.printf("%nCompleted in %s%n%n", Util.prettyPrintTime((long)(System.currentTimeMillis() - start)));
            } else {
                System.out.println("Slave node waiting for Map/Reduce tasks.  Ctrl-C to exit.");
                LockSupport.park();
            }
        }
        finally {
            cache.getCacheManager().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData(Cache<String, String> cache) throws IOException {
        FileReader in = new FileReader(this.textFile);
        try {
            BufferedReader bufferedReader = new BufferedReader(in);
            int chunkSize = 10;
            int chunkId = 0;
            CharBuffer cbuf = CharBuffer.allocate(1024 * chunkSize);
            while (bufferedReader.read(cbuf) >= 0) {
                Buffer buffer = cbuf.flip();
                String textChunk = buffer.toString();
                cache.put((Object)(this.textFile + chunkId++), (Object)textChunk);
                cbuf.clear();
                if (chunkId % 100 != 0) continue;
                System.out.printf("  Inserted %s chunks from %s into grid%n", chunkId, this.textFile);
            }
        }
        finally {
            Util.close((Closeable)in);
        }
    }

    @Override
    protected SimpleJSAP buildCommandLineOptions() throws JSAPException {
        return new SimpleJSAP("WordCountDemo", "Count words in Infinispan cache usin MapReduceTask ", new Parameter[]{new FlaggedOption("configFile", (StringParser)JSAP.STRING_PARSER, "config-samples/distributed-udp.xml", false, 'c', "configFile", "Infinispan transport config file"), new FlaggedOption("nodeType", (StringParser)JSAP.STRING_PARSER, "slave", true, 't', "nodeType", "Node type as either master or slave"), new FlaggedOption("textFile", (StringParser)JSAP.STRING_PARSER, null, false, 'f', "textFile", "Input text file to distribute onto grid"), new FlaggedOption("mostPopularWords", (StringParser)JSAP.INTEGER_PARSER, "15", false, 'n', "mostPopularWords", "Number of most popular words to find")});
    }
}

