/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedCallable;

public class CacheValueRegEx<K, V, T>
implements DistributedCallable<K, String, List<K>>,
Serializable {
    Cache<K, String> cache;
    Set<K> keys;
    public String pattern = "The Project Gutenberg EBook of The Complete Works of William Shakespeare";

    public void setEnvironment(Cache<K, String> cache, Set<K> keys) {
        this.cache = cache;
        this.keys = keys;
    }

    public List<K> call() throws Exception {
        ArrayList result = new ArrayList();
        Pattern regexp = Pattern.compile(this.pattern);
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info("Searching for regular expression '" + this.pattern + "'");
        for (Map.Entry entry : this.cache.entrySet()) {
            int foundCount = 0;
            String valueString = (String)entry.getValue();
            Matcher matcher = regexp.matcher(valueString);
            while (matcher.find()) {
                ++foundCount;
            }
            if (foundCount <= 0) continue;
            logger.finest("Found regular expression '" + this.pattern + "' " + foundCount + " times in key '" + entry.getKey() + "'");
            result.add(entry.getKey());
        }
        return result;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

