/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo;

import com.martiansoftware.jsap.JSAPResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.ec2demo.CacheBuilder;
import org.infinispan.ec2demo.Influenza_N_P_CR_Element;
import org.infinispan.ec2demo.Influenza_Parser;
import org.infinispan.ec2demo.Nucleotide_Protein_Element;
import org.infinispan.ec2demo.Nucleotide_Protein_Parser;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.xml.sax.SAXException;

public class InfluenzaDataLoader {
    private CacheBuilder cbuilder;
    private Cache<String, Influenza_N_P_CR_Element> influenzaCache;
    private Cache<String, Nucleotide_Protein_Element> proteinCache;
    private Cache<String, Nucleotide_Protein_Element> nucleiodCache;
    private Nucleotide_Protein_Parser npParser;
    private Influenza_Parser iParser;
    private static final Log myLogger = LogFactory.getLog(InfluenzaDataLoader.class);

    public void createCache(String configFile) throws IOException {
        String cfgFileName = System.getProperty("infinispan.demo.cfg");
        if (cfgFileName == null) {
            cfgFileName = configFile;
        }
        this.cbuilder = new CacheBuilder(cfgFileName);
        this.influenzaCache = this.cbuilder.getCacheManager().getCache("InfluenzaCache");
        this.proteinCache = this.cbuilder.getCacheManager().getCache("ProteinCache");
        this.nucleiodCache = this.cbuilder.getCacheManager().getCache("NucleotideCache");
    }

    public void populateCache(JSAPResult config) throws SAXException {
        try {
            List npList;
            this.npParser = new Nucleotide_Protein_Parser();
            this.iParser = new Influenza_Parser();
            System.out.println("Caches created....Starting CacheManager");
            this.cbuilder.getCacheManager().start();
            int loadLimit = config.getInt("count");
            List z = this.cbuilder.getCacheManager().getMembers();
            for (Address k : z) {
                if (k == null) continue;
                System.out.println("Cache Address=" + k.toString());
            }
            System.out.println("Parsing files....");
            if (config.getString("ifile") != null) {
                myLogger.info((Object)"Parsing Influenza data");
                List iList = this.iParser.parseFile(config.getString("ifile"));
                boolean rQuery = config.getBoolean("randomquery");
                int lSize = iList.size() - 1;
                if (rQuery) {
                    System.out.println("Performing random queries");
                    Random randomGenerator = new Random();
                    while (true) {
                        int currRec = randomGenerator.nextInt(lSize);
                        Influenza_N_P_CR_Element curreElem = (Influenza_N_P_CR_Element)iList.get(currRec);
                        this.searchCache(curreElem.getGanNucleoid());
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                System.out.println("About to load " + iList.size() + " influenza elements into influenzaCache");
                int loopCount = 0;
                this.influenzaCache.startBatch();
                for (Influenza_N_P_CR_Element x : iList) {
                    this.influenzaCache.put((Object)x.getGanNucleoid(), (Object)x);
                    if (++loopCount % 5000 == 0) {
                        System.out.println("Added " + loopCount + " Influenza records");
                        this.influenzaCache.endBatch(true);
                        this.influenzaCache.startBatch();
                    }
                    if (loopCount != loadLimit) continue;
                    System.out.println("Limited to " + loadLimit + " records");
                    break;
                }
                this.influenzaCache.endBatch(true);
                System.out.println("Loaded " + this.influenzaCache.size() + " influenza elements into influenzaCache");
            }
            if (config.getString("pfile") != null) {
                myLogger.info((Object)"Parsing Protein data");
                npList = this.npParser.parseFile(config.getString("pfile"));
                System.out.println("About to load " + npList.size() + " protein elements into ProteinCache");
                int loopCount = 0;
                this.proteinCache.startBatch();
                for (Nucleotide_Protein_Element x : npList) {
                    this.proteinCache.put((Object)x.getGenbankAccessionNumber(), (Object)x);
                    if (++loopCount % 5000 == 0) {
                        System.out.println("Added " + loopCount + " protein records");
                        this.proteinCache.endBatch(true);
                        this.proteinCache.startBatch();
                    }
                    if (loopCount != loadLimit) continue;
                    System.out.println("Limited to " + loadLimit + " records");
                    break;
                }
                this.proteinCache.endBatch(true);
                System.out.println("Loaded " + this.proteinCache.size() + " protein elements into ProteinCache");
            }
            if (config.getString("nfile") != null) {
                myLogger.info((Object)"Parsing Nucleotide data");
                npList = this.npParser.parseFile(config.getString("nfile"));
                System.out.println("About to load " + npList.size() + " nucleotide elements into NucleiodCache");
                int loopCount = 0;
                this.nucleiodCache.startBatch();
                for (Nucleotide_Protein_Element x : npList) {
                    this.nucleiodCache.put((Object)x.getGenbankAccessionNumber(), (Object)x);
                    if (++loopCount % 5000 == 0) {
                        System.out.println("Added " + loopCount + " Nucleotide records");
                        this.nucleiodCache.endBatch(true);
                        this.nucleiodCache.startBatch();
                    }
                    if (loopCount != loadLimit) continue;
                    System.out.println("Limited to " + loadLimit + " records");
                    break;
                }
                this.nucleiodCache.endBatch(true);
                System.out.println("Loaded " + this.nucleiodCache.size() + " nucleotide elements into NucleiodCache");
            }
            System.out.println("Parsing files....Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void searchCache(String inGBAN) {
        myLogger.trace((Object)("Searching influenzaCache for " + inGBAN));
        Influenza_N_P_CR_Element myRec = (Influenza_N_P_CR_Element)this.influenzaCache.get((Object)inGBAN);
        if (myRec != null) {
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.println("Virus Details->" + myRec);
            myLogger.trace((Object)("Searching nucleiodCache for " + myRec.getGanNucleoid()));
            Nucleotide_Protein_Element nucldet = (Nucleotide_Protein_Element)this.nucleiodCache.get((Object)myRec.getGanNucleoid());
            System.out.println("Nucleotide details->" + nucldet);
            Map myProt = myRec.getProtein_Data();
            for (String x : myProt.keySet()) {
                System.out.println("=========================================================================");
                myLogger.trace((Object)("Searching proteinCache for " + x));
                Nucleotide_Protein_Element myProtdet = (Nucleotide_Protein_Element)this.proteinCache.get((Object)x);
                System.out.println("Protein->" + myProtdet);
                String protein_CR = (String)myProt.get(x);
                System.out.println("Protein coding region->" + protein_CR);
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        } else {
            myLogger.trace((Object)("No virus data found for " + inGBAN));
            System.out.println("No virus data found for " + inGBAN);
        }
    }

    public String cacheSizes() {
        return "Protein/Influenza/Nucleotide Cache Size-->" + this.proteinCache.size() + "/" + this.influenzaCache.size() + "/" + this.nucleiodCache.size();
    }
}

