/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo;

import java.io.IOException;
import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheBuilder {
    private CacheManager cache_manager;
    private static final Log myLogger = LogFactory.getLog(CacheBuilder.class);

    public CacheBuilder(String inConfigFile) throws IOException {
        String configFile = System.getProperty("EC2Demo-jgroups-config");
        if (configFile == null || configFile.isEmpty()) {
            configFile = inConfigFile;
        }
        if (configFile == null || configFile.isEmpty()) {
            throw new RuntimeException("Need to either set system property EC2Demo-jgroups-config to point to the jgroups configuration file or pass in the the location of the jgroups configuration file");
        }
        System.out.println("CacheBuilder called with " + configFile);
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        gc.setClusterName("infinispan-demo-cluster");
        gc.setTransportClass(JGroupsTransport.class.getName());
        Properties p = new Properties();
        p.setProperty("configurationFile", configFile);
        gc.setTransportProperties(p);
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        c.setExposeJmxStatistics(true);
        c.setUnsafeUnreliableReturnValues(true);
        c.setNumOwners(3);
        c.setL1CacheEnabled(true);
        c.setInvocationBatchingEnabled(true);
        c.setUseReplQueue(true);
        c.setL1Lifespan(6000000L);
        this.cache_manager = new DefaultCacheManager(gc, c, false);
    }

    public CacheManager getCacheManager() {
        return this.cache_manager;
    }
}

