/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.ec2demo.CacheBuilder;
import org.infinispan.ec2demo.Influenza_N_P_CR_Element;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfluenzaVirusCache {
    private static final Log log = LogFactory.getLog(InfluenzaVirusCache.class);
    private Cache<String, Influenza_N_P_CR_Element> myCache;

    public InfluenzaVirusCache(CacheBuilder cacheManger) throws IOException {
        this.myCache = cacheManger.getCacheManager().getCache("InfluenzaCache");
    }

    public void addToCache(Influenza_N_P_CR_Element value) {
        if (value == null) {
            return;
        }
        String myKey = value.getGanNucleoid();
        if (myKey == null || myKey.isEmpty()) {
            log.error((Object)("Invalid record " + value));
        } else {
            this.myCache.put((Object)myKey, (Object)value);
        }
    }

    public int getCacheSize() {
        return this.myCache.size();
    }

    public Influenza_N_P_CR_Element getVirusDetails(String GBAN) {
        return (Influenza_N_P_CR_Element)this.myCache.get((Object)GBAN);
    }

    public Cache<String, Influenza_N_P_CR_Element> getCache() {
        return this.myCache;
    }
}

