/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import infinispan.org.apache.commons.compress.compressors.CompressorException;
import infinispan.org.apache.commons.compress.compressors.CompressorStreamFactory;
import infinispan.org.apache.commons.compress.utils.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8102;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    public CommonsCompressAction(String name, File source, File destination, boolean deleteSource) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.name = name;
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
    }

    @Override
    public boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    public static boolean execute(String name, File source, File destination, boolean deleteSource) throws IOException {
        if (!source.exists()) {
            return false;
        }
        try (FileInputStream input = new FileInputStream(source);
             BufferedOutputStream output = new BufferedOutputStream(new CompressorStreamFactory().createCompressorOutputStream(name, new FileOutputStream(destination)));){
            IOUtils.copy(input, output, 8102);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
        if (deleteSource && !source.delete()) {
            LOGGER.warn("Unable to delete " + source.toString() + '.');
        }
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return CommonsCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public String getName() {
        return this.name;
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

