/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneIndexingParameters
implements Serializable {
    private static final long serialVersionUID = 5424606407623591663L;
    private static final Log log = LoggerFactory.make();
    public static final String EXPLICIT_DEFAULT_VALUE = "default";
    public static final String PROP_GROUP = "indexwriter";
    private final ParameterSet indexParameters;

    public LuceneIndexingParameters(Properties sourceProps) {
        MaskedProperty indexingParameters = new MaskedProperty(sourceProps, PROP_GROUP);
        this.indexParameters = new ParameterSet(indexingParameters);
    }

    public ParameterSet getIndexParameters() {
        return this.indexParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LuceneIndexingParameters{");
        sb.append(this.indexParameters);
        sb.append('}');
        return sb.toString();
    }

    public void applyToWriter(IndexWriterConfig writerConfig) {
        this.getIndexParameters().applyToWriter(writerConfig);
    }

    public static class ParameterSet
    implements Serializable {
        private static final long serialVersionUID = -6121723702279869524L;
        final Map<IndexWriterSetting, Integer> parameters = new EnumMap<IndexWriterSetting, Integer>(IndexWriterSetting.class);

        public ParameterSet(Properties prop) {
            for (IndexWriterSetting t : IndexWriterSetting.values()) {
                String key = t.getKey();
                String value = prop.getProperty(key);
                if (value == null || LuceneIndexingParameters.EXPLICIT_DEFAULT_VALUE.equalsIgnoreCase(value)) continue;
                if (log.isDebugEnabled()) {
                    log.debugf("Set index writer parameter %s to value : %s", (Object)key, (Object)value);
                }
                this.parameters.put(t, t.parseVal(value));
            }
        }

        public void applyToWriter(IndexWriterConfig writerConfig) {
            for (Map.Entry<IndexWriterSetting, Integer> entry : this.parameters.entrySet()) {
                try {
                    entry.getKey().applySetting(writerConfig, (int)entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException("Illegal IndexWriter setting " + entry.getKey().getKey() + " " + e.getMessage(), e);
                }
            }
        }

        public LogByteSizeMergePolicy getNewMergePolicy() {
            LogByteSizeMergePolicy logByteSizeMergePolicy = new LogByteSizeMergePolicy();
            for (Map.Entry<IndexWriterSetting, Integer> entry : this.parameters.entrySet()) {
                try {
                    entry.getKey().applySetting(logByteSizeMergePolicy, (int)entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException("Illegal IndexWriter setting " + entry.getKey().getKey() + " " + e.getMessage(), e);
                }
            }
            return logByteSizeMergePolicy;
        }

        public Integer getCurrentValueFor(IndexWriterSetting ws) {
            return this.parameters.get(ws);
        }

        public void setCurrentValueFor(IndexWriterSetting ws, Integer newValue) {
            if (newValue == null) {
                this.parameters.remove(ws);
            } else {
                this.parameters.put(ws, newValue);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterSet other = (ParameterSet)obj;
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ParameterSet");
            sb.append("{parameters=").append(this.parameters);
            sb.append('}');
            return sb.toString();
        }
    }
}

