/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.DocumentBuilderHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.impl.ConnectedMoreLikeThisQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.MoreLikeThisQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class MoreLikeThisBuilder<T> {
    private static final Log log = LoggerFactory.make();
    private final int minWordLen = 0;
    private final int maxNumTokensParsed = 5000;
    private final int maxWordLen = 0;
    private final Set<?> stopWords = MoreLikeThis.DEFAULT_STOP_WORDS;
    private final DocumentBuilderIndexedEntity documentBuilder;
    private final int minTermFreq = 1;
    private final int minDocFreq = 1;
    private final int maxDocFreq = Integer.MAX_VALUE;
    private final int maxQueryTerms = 25;
    private boolean boost = false;
    private float boostFactor = 1.0f;
    private TFIDFSimilarity similarity;
    private Integer documentNumber;
    private String[] compatibleFieldNames;
    private IndexReader indexReader;
    private FieldsContext fieldsContext;
    private Object input;
    private QueryBuildingContext queryContext;
    private boolean excludeEntityCompared;
    private ConnectedMoreLikeThisQueryBuilder.INPUT_TYPE inputType;
    private TermQuery findById;

    public MoreLikeThisBuilder(DocumentBuilderIndexedEntity documentBuilder, ExtendedSearchIntegrator searchIntegrator) {
        this.documentBuilder = documentBuilder;
        Similarity configuredSimilarity = searchIntegrator.getIndexBindings().get(documentBuilder.getBeanClass()).getSimilarity();
        if (!(configuredSimilarity instanceof TFIDFSimilarity)) {
            throw log.requireTFIDFSimilarity(documentBuilder.getBeanClass());
        }
        this.similarity = (TFIDFSimilarity)configuredSimilarity;
    }

    public MoreLikeThisBuilder indexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
        return this;
    }

    public MoreLikeThisBuilder compatibleFieldNames(String ... compatibleFieldNames) {
        this.compatibleFieldNames = compatibleFieldNames;
        return this;
    }

    public MoreLikeThisBuilder otherMoreLikeThisContext(MoreLikeThisQueryContext moreLikeThisContext) {
        this.boost = moreLikeThisContext.isBoostTerms();
        this.boostFactor = moreLikeThisContext.getTermBoostFactor();
        this.excludeEntityCompared = moreLikeThisContext.isExcludeEntityUsedForComparison();
        return this;
    }

    public Query createQuery() {
        try {
            this.documentNumber = this.getLuceneDocumentIdFromIdAsTermOrNull(this.documentBuilder);
            return this.maybeExcludeComparedEntity(this.createQuery(this.retrieveTerms()));
        }
        catch (IOException e) {
            throw log.ioExceptionOnIndexOfEntity(e, this.documentBuilder.getBeanClass());
        }
    }

    private Integer getLuceneDocumentIdFromIdAsTermOrNull(DocumentBuilderIndexedEntity documentBuilder) {
        String id;
        if (this.inputType == ConnectedMoreLikeThisQueryBuilder.INPUT_TYPE.ID) {
            id = documentBuilder.getIdBridge().objectToString(this.input);
        } else if (this.inputType == ConnectedMoreLikeThisQueryBuilder.INPUT_TYPE.ENTITY) {
            try {
                id = documentBuilder.getIdBridge().objectToString(documentBuilder.getId(this.input));
            }
            catch (IllegalStateException e) {
                id = null;
            }
        } else {
            throw new AssertionFailure("We don't support string and reader for MoreLikeThis");
        }
        if (id == null) {
            return null;
        }
        this.findById = new TermQuery(new Term(documentBuilder.getIdKeywordName(), id));
        HSQuery query = this.queryContext.getFactory().createHSQuery();
        ArrayList classes = new ArrayList(1);
        classes.add(this.queryContext.getEntityType());
        List<EntityInfo> entityInfos = query.luceneQuery(this.findById).maxResults(1).projection("__HSearch_DocumentId").targetedEntities(classes).queryEntityInfos();
        if (entityInfos.size() == 0) {
            if (this.inputType == ConnectedMoreLikeThisQueryBuilder.INPUT_TYPE.ID) {
                throw log.entityWithIdNotFound(this.queryContext.getEntityType(), id);
            }
            return null;
        }
        return (Integer)entityInfos.iterator().next().getProjection()[0];
    }

    private Query maybeExcludeComparedEntity(Query query) {
        if (this.excludeEntityCompared && this.documentNumber != null) {
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(new ConstantScoreQuery(this.findById), BooleanClause.Occur.MUST_NOT).build();
        }
        return query;
    }

    private Query createQuery(List<PriorityQueue<Object[]>> q) {
        int length = this.fieldsContext.size();
        if (length == 0) {
            throw new AssertionFailure("Querying MoreLikeThis on 0 field.");
        }
        if (length == 1) {
            return this.createQuery(q.get(0), this.fieldsContext.getFirst());
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        Iterator<FieldContext> fieldsContextIterator = this.fieldsContext.iterator();
        for (PriorityQueue<Object[]> queue : q) {
            try {
                queryBuilder.add(this.createQuery(queue, fieldsContextIterator.next()), BooleanClause.Occur.SHOULD);
            }
            catch (BooleanQuery.TooManyClauses ignore) {
                break;
            }
        }
        return queryBuilder.build();
    }

    private Query createQuery(PriorityQueue<Object[]> q, FieldContext fieldContext) {
        Object[] cur;
        if (q == null) {
            boolean isIdOrEmbeddedId;
            boolean isStored;
            FieldBridge fieldBridge;
            FieldBridge fieldBridge2 = fieldBridge = fieldContext.getFieldBridge() != null ? fieldContext.getFieldBridge() : this.documentBuilder.getBridge(fieldContext.getField());
            if (fieldBridge instanceof NumericFieldBridge) {
                throw log.numericFieldCannotBeUsedInMoreLikeThis(fieldContext.getField(), this.documentBuilder.getBeanClass());
            }
            DocumentFieldMetadata fieldMetadata = this.documentBuilder.getTypeMetadata().getDocumentFieldMetadataFor(fieldContext.getField());
            if (fieldMetadata == null) {
                throw log.unknownFieldNameForMoreLikeThisQuery(fieldContext.getField(), this.documentBuilder.getBeanClass().getName());
            }
            boolean hasTermVector = fieldMetadata.getTermVector() != Field.TermVector.NO;
            boolean bl = isStored = fieldMetadata.getStore() != Store.NO;
            if (!hasTermVector && !isStored) {
                throw log.fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis(fieldContext.getField(), this.documentBuilder.getBeanClass());
            }
            boolean bl2 = isIdOrEmbeddedId = fieldMetadata.isId() || fieldMetadata.isIdInEmbedded();
            if (isIdOrEmbeddedId) {
                throw log.fieldIdCannotBeUsedInMoreLikeThis(fieldContext.getField(), this.documentBuilder.getBeanClass());
            }
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        int qterms = 0;
        float bestScore = 0.0f;
        while ((cur = q.pop()) != null) {
            Object[] ar = cur;
            TermQuery tq = new TermQuery(new Term((String)ar[1], (String)ar[0]));
            if (this.boost) {
                if (qterms == 0) {
                    bestScore = ((Float)ar[2]).floatValue();
                }
                float myScore = ((Float)ar[2]).floatValue();
                tq.setBoost(this.boostFactor * myScore / bestScore);
            }
            try {
                queryBuilder.add(tq, BooleanClause.Occur.SHOULD);
            }
            catch (BooleanQuery.TooManyClauses ignore) {
                break;
            }
            if (++qterms < 25) continue;
            break;
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(queryBuilder.build()).createQuery();
    }

    private List<PriorityQueue<Object[]>> retrieveTerms() throws IOException {
        Fields vectors;
        int size = this.fieldsContext.size();
        HashMap<String, HashMap<String, Int>> termFreqMapPerFieldname = new HashMap<String, HashMap<String, Int>>(size);
        Document maybeDocument = null;
        if (this.documentNumber == null && size > 0) {
            String[] fieldNames = new String[size];
            Iterator<FieldContext> fieldsContextIterator = this.fieldsContext.iterator();
            for (int index = 0; index < size; ++index) {
                fieldNames[index] = fieldsContextIterator.next().getField();
            }
            HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
            maybeDocument = this.documentBuilder.getDocument(null, this.input, null, fieldToAnalyzerMap, null, new ContextualExceptionBridgeHelper(), fieldNames);
            vectors = null;
        } else {
            vectors = this.indexReader.getTermVectors(this.documentNumber);
        }
        for (FieldContext fieldContext : this.fieldsContext) {
            String fieldName = fieldContext.getField();
            if (this.isCompatibleField(fieldName)) {
                HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
                termFreqMapPerFieldname.put(fieldName, termFreqMap);
                Terms vector = vectors != null ? vectors.terms(fieldName) : null;
                if (vector == null) {
                    IndexableField[] fields;
                    if (maybeDocument == null) {
                        maybeDocument = this.indexReader.document(this.documentNumber);
                    }
                    for (IndexableField field : fields = maybeDocument.getFields(fieldName)) {
                        String stringValue = DocumentBuilderHelper.extractStringFromFieldable(field);
                        if (stringValue == null) continue;
                        this.addTermFrequencies(new StringReader(stringValue), termFreqMap, fieldContext);
                    }
                    continue;
                }
                this.addTermFrequencies(termFreqMap, vector);
                continue;
            }
            termFreqMapPerFieldname.put(fieldName, null);
        }
        ArrayList<PriorityQueue<Object[]>> results = new ArrayList<PriorityQueue<Object[]>>(size);
        for (Map.Entry entry : termFreqMapPerFieldname.entrySet()) {
            results.add(this.createQueue((String)entry.getKey(), (Map)entry.getValue()));
        }
        return results;
    }

    private boolean isCompatibleField(String fieldName) {
        for (String compatibleFieldName : this.compatibleFieldNames) {
            if (!compatibleFieldName.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private PriorityQueue<Object[]> createQueue(String fieldName, Map<String, Int> words) throws IOException {
        if (words == null) {
            return null;
        }
        int numDocs = this.indexReader.numDocs();
        FreqQ res = new FreqQ(words.size());
        for (Map.Entry<String, Int> entry : words.entrySet()) {
            String word = entry.getKey();
            int tf = entry.getValue().x;
            if (tf < 1) continue;
            Term term = new Term(fieldName, word);
            int freq = this.indexReader.docFreq(new Term(fieldName, word));
            if (freq < 1 || freq > Integer.MAX_VALUE || freq == 0) continue;
            float idf = this.similarity.idf(freq, numDocs);
            float score = (float)tf * idf;
            res.insertWithOverflow(new Object[]{word, fieldName, Float.valueOf(score), Float.valueOf(idf), freq, tf});
        }
        return res;
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, Terms vector) throws IOException {
        BytesRef text;
        TermsEnum termsEnum = vector.iterator();
        char[] charBuffer = new char[]{};
        CharsRef outputReference = new CharsRef();
        while ((text = termsEnum.next()) != null) {
            charBuffer = ArrayUtil.grow(charBuffer, text.length);
            int stringLenght = UnicodeUtil.UTF8toUTF16(text, charBuffer);
            outputReference.chars = charBuffer;
            outputReference.length = stringLenght;
            String term = outputReference.toString();
            if (this.isNoiseWord(term)) continue;
            int freq = (int)termsEnum.totalTermFreq();
            Int cnt = termFreqMap.get(term);
            if (cnt == null) {
                cnt = new Int();
                termFreqMap.put(term, cnt);
                cnt.x = freq;
                continue;
            }
            cnt.x += freq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTermFrequencies(Reader r, Map<String, Int> termFreqMap, FieldContext fieldContext) throws IOException {
        String fieldName = fieldContext.getField();
        Analyzer analyzer = this.queryContext.getQueryAnalyzerReference().unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        if (!fieldContext.applyAnalyzer()) {
            analyzer = PassThroughAnalyzer.INSTANCE;
        }
        TokenStream ts = analyzer.tokenStream(fieldName, r);
        try {
            int tokenCount = 0;
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String word = termAtt.toString();
                if (++tokenCount > 5000) break;
                if (this.isNoiseWord(word)) continue;
                Int cnt = termFreqMap.get(word);
                if (cnt == null) {
                    termFreqMap.put(word, new Int());
                    continue;
                }
                ++cnt.x;
            }
            ts.end();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(ts);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(ts);
    }

    private boolean isNoiseWord(String term) {
        int len = term.length();
        return this.stopWords != null && this.stopWords.contains(term);
    }

    public MoreLikeThisBuilder fieldsContext(FieldsContext fieldsContext) {
        this.fieldsContext = fieldsContext;
        return this;
    }

    public MoreLikeThisBuilder input(Object input) {
        this.input = input;
        return this;
    }

    public MoreLikeThisBuilder queryContext(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        return this;
    }

    public MoreLikeThisBuilder idAsTerm(String idAsTerm) {
        return this;
    }

    public MoreLikeThisBuilder inputType(ConnectedMoreLikeThisQueryBuilder.INPUT_TYPE inputType) {
        this.inputType = inputType;
        return this;
    }

    private static class Int {
        int x = 1;

        Int() {
        }

        public String toString() {
            return "Int{" + this.x + '}';
        }
    }

    private static class FreqQ
    extends PriorityQueue<Object[]> {
        FreqQ(int s) {
            super(s);
        }

        @Override
        protected boolean lessThan(Object[] aa, Object[] bb) {
            Float fa = (Float)aa[2];
            Float fb = (Float)bb[2];
            return fa.floatValue() > fb.floatValue();
        }
    }
}

