/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.util.ToStringUtils;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.query.dsl.impl.AbstractRemoteQueryWithAnalyzer;

public class RemotePhraseQuery
extends AbstractRemoteQueryWithAnalyzer {
    private String field;
    private String phrase;
    private int slop;

    public RemotePhraseQuery(String field, int slop, String phrase, RemoteAnalyzerReference analyzerReference) {
        super(analyzerReference);
        this.field = field;
        this.slop = slop;
        this.phrase = phrase;
    }

    public String getField() {
        return this.field;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public int getSlop() {
        return this.slop;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("<");
        sb.append(field).append(":");
        sb.append("\"").append(this.phrase).append("\"");
        if (this.slop != 0) {
            sb.append("~").append(this.slop);
        }
        sb.append(ToStringUtils.boost(this.getBoost()));
        if (this.getAnalyzerReference() != null) {
            sb.append(",analyzer=").append(this.getAnalyzerReference());
        }
        sb.append(">");
        return sb.toString();
    }
}

