/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class SpatialHashFilter
extends Filter {
    private final List<String> spatialHashCellsIds;
    private final String fieldName;

    public SpatialHashFilter(List<String> spatialHashCellsIds, String fieldName) {
        this.spatialHashCellsIds = spatialHashCellsIds;
        this.fieldName = fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        if (this.spatialHashCellsIds.size() == 0) {
            return null;
        }
        LeafReader atomicReader = context.reader();
        BitDocIdSet matchedDocumentsIds = new BitDocIdSet(new FixedBitSet(atomicReader.maxDoc()));
        Boolean found = false;
        for (int i = 0; i < this.spatialHashCellsIds.size(); ++i) {
            int docId;
            Term spatialHashCellTerm = new Term(this.fieldName, this.spatialHashCellsIds.get(i));
            DocsEnum spatialHashCellsDocs = atomicReader.termDocsEnum(spatialHashCellTerm);
            if (spatialHashCellsDocs == null) continue;
            while ((docId = spatialHashCellsDocs.nextDoc()) != Integer.MAX_VALUE) {
                if (acceptDocs != null && !acceptDocs.get(docId)) continue;
                matchedDocumentsIds.bits().set(docId);
                found = true;
            }
        }
        if (found.booleanValue()) {
            return matchedDocumentsIds;
        }
        return null;
    }

    public List<String> getSpatialHashCellsIds() {
        return Collections.unmodifiableList(this.spatialHashCellsIds);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("SpatialHashFilter");
        sb.append("{spatialHashCellsIds=").append(this.spatialHashCellsIds);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

