/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search.impl;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.hibernate.search.impl.AsyncDeleteExecutorService;
import org.infinispan.hibernate.search.logging.Log;

public class DefaultAsyncDeleteExecutor
implements AsyncDeleteExecutorService,
Startable,
Stoppable {
    private static final Log log = LoggerFactory.make(Log.class);
    private ThreadPoolExecutor threadPool;

    @Override
    public void start(Properties properties, BuildContext context) {
        this.threadPool = Executors.newScalableThreadPool(1, 5, "async deletion of index segments", 100);
    }

    @Override
    public void stop() {
        this.closeAndFlush();
    }

    @Override
    public Executor getExecutor() {
        return this.threadPool;
    }

    @Override
    public void closeAndFlush() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForAsyncDeleteFlush();
        }
    }
}

