/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.Cache;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.SlicingInfinispanIndexInput;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexInput
extends IndexInput {
    private static final Log log = LogFactory.getLog(InfinispanIndexInput.class);
    private static final boolean trace = log.isTraceEnabled();
    protected boolean isClone;
    private final Cache<ChunkCacheKey, Object> chunksCache;
    private final FileCacheKey fileKey;
    private final int chunkSize;
    private final SegmentReadLocker readLocks;
    private final String filename;
    private final long fileLength;
    private final int affinitySegmentId;
    private int currentBufferSize;
    private byte[] buffer;
    private int bufferPosition;
    private int currentLoadedChunk = -1;

    public InfinispanIndexInput(IndexInputContext ctx) {
        super(ctx.fileKey.getFileName());
        this.chunksCache = ctx.chunksCache;
        this.fileKey = ctx.fileKey;
        this.chunkSize = ctx.fileMetadata.getBufferSize();
        this.fileLength = ctx.fileMetadata.getSize();
        this.readLocks = ctx.readLocks;
        this.affinitySegmentId = ctx.affinitySegmentId;
        this.filename = this.fileKey.getFileName();
        if (trace) {
            log.tracef("Opened new IndexInput for file:%s in index: %s", (Object)this.filename, (Object)this.fileKey.getIndexName());
        }
    }

    private InfinispanIndexInput(String resourceDescription, Cache<ChunkCacheKey, Object> chunksCache, FileCacheKey fileKey, int chunkSize, String filename, long fileLength, int affinitySegmentId) {
        super(resourceDescription);
        this.chunksCache = chunksCache;
        this.fileKey = fileKey;
        this.chunkSize = chunkSize;
        this.filename = filename;
        this.fileLength = fileLength;
        this.readLocks = null;
        this.affinitySegmentId = affinitySegmentId;
        this.isClone = true;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.bufferPosition >= this.currentBufferSize) {
            this.nextChunk();
            this.bufferPosition = 0;
        }
        return this.buffer[this.bufferPosition++];
    }

    @Override
    public final void readBytes(byte[] b, int offset, int bytesToRead) throws IOException {
        if (this.buffer == null) {
            this.nextChunk();
        }
        while (bytesToRead > 0) {
            int bytesToCopy = Math.min(this.currentBufferSize - this.bufferPosition, bytesToRead);
            System.arraycopy(this.buffer, this.bufferPosition, b, offset, bytesToCopy);
            offset += bytesToCopy;
            this.bufferPosition += bytesToCopy;
            if (this.bufferPosition < this.currentBufferSize || (bytesToRead -= bytesToCopy) <= 0) continue;
            this.nextChunk();
            this.bufferPosition = 0;
        }
    }

    @Override
    public void close() {
        this.currentBufferSize = 0;
        this.bufferPosition = 0;
        this.currentLoadedChunk = -1;
        this.buffer = null;
        if (this.isClone) {
            return;
        }
        this.readLocks.deleteOrReleaseReadLock(this.filename);
        if (trace) {
            log.tracef("Closed IndexInput for file:%s in index: %s", (Object)this.filename, (Object)this.fileKey.getIndexName());
        }
    }

    @Override
    public long getFilePointer() {
        return (long)this.currentLoadedChunk * (long)this.chunkSize + (long)this.bufferPosition;
    }

    @Override
    public void seek(long pos) {
        this.bufferPosition = (int)(pos % (long)this.chunkSize);
        int targetChunk = (int)(pos / (long)this.chunkSize);
        if (targetChunk != this.currentLoadedChunk) {
            this.currentLoadedChunk = targetChunk;
            this.setBufferToCurrentChunkIfPossible();
        }
    }

    private void nextChunk() throws IOException {
        ++this.currentLoadedChunk;
        this.setBufferToCurrentChunk();
    }

    private void setBufferToCurrentChunk() throws IOException {
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.filename, this.currentLoadedChunk, this.chunkSize, this.affinitySegmentId);
        this.buffer = (byte[])this.chunksCache.get((Object)key);
        if (this.buffer == null) {
            throw new IOException("Read past EOF: Chunk value could not be found for key " + key);
        }
        this.currentBufferSize = this.buffer.length;
    }

    private void setBufferToCurrentChunkIfPossible() {
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.filename, this.currentLoadedChunk, this.chunkSize, this.affinitySegmentId);
        this.buffer = (byte[])this.chunksCache.get((Object)key);
        if (this.buffer == null) {
            --this.currentLoadedChunk;
            this.bufferPosition = this.chunkSize;
        } else {
            this.currentBufferSize = this.buffer.length;
        }
    }

    @Override
    public long length() {
        return this.fileLength;
    }

    @Override
    public InfinispanIndexInput clone() {
        InfinispanIndexInput clone = (InfinispanIndexInput)super.clone();
        clone.isClone = true;
        return clone;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new SlicingInfinispanIndexInput(sliceDescription, offset, length, this.copyAndReset());
    }

    InfinispanIndexInput copyAndReset() {
        return new InfinispanIndexInput(this.filename, this.chunksCache, this.fileKey, this.chunkSize, this.filename, this.fileLength, this.affinitySegmentId);
    }
}

