/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.BETreeMaker;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.util.StringHelper;

public final class FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    private final PredicateIndex<AttributeMetadata, AttributeId> predicateIndex;
    private final List<FilterSubscriptionImpl> filterSubscriptions = new ArrayList<FilterSubscriptionImpl>();
    private final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();
    private final BETreeMaker<AttributeId> treeMaker;
    private final MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter;
    private final boolean useIntervals;

    public FilterRegistry(MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter, boolean useIntervals) {
        this.metadataAdapter = metadataAdapter;
        this.useIntervals = useIntervals;
        this.treeMaker = new BETreeMaker<AttributeId>(metadataAdapter, useIntervals);
        this.predicateIndex = new PredicateIndex<AttributeMetadata, AttributeId>(metadataAdapter);
    }

    public MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> getMetadataAdapter() {
        return this.metadataAdapter;
    }

    public PredicateIndex<AttributeMetadata, AttributeId> getPredicateIndex() {
        return this.predicateIndex;
    }

    public List<FilterSubscriptionImpl> getFilterSubscriptions() {
        return this.filterSubscriptions;
    }

    /*
     * WARNING - void declaration
     */
    public FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> addFilter(String queryString, Map<String, Object> namedParameters, BooleanExpr query, String[] projection, Class<?>[] projectionTypes, SortField[] sortFields, FilterCallback callback, Object[] eventTypes) {
        if (eventTypes != null) {
            if (eventTypes.length == 0) {
                eventTypes = null;
            } else {
                for (Object object : eventTypes) {
                    if (object != null) continue;
                    eventTypes = null;
                    break;
                }
            }
        }
        ArrayList translatedProjections = null;
        if (projection != null && projection.length != 0) {
            void var12_18;
            translatedProjections = new ArrayList(projection.length);
            String[] stringArray = projection;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_18 < n) {
                String projectionPath = stringArray[var12_18];
                translatedProjections.add(this.metadataAdapter.mapPropertyNamePathToFieldIdPath(StringHelper.split(projectionPath)));
                ++var12_18;
            }
        }
        ArrayList translatedSortFields = null;
        if (sortFields != null) {
            LinkedHashMap<String, SortField> sortFieldMap = new LinkedHashMap<String, SortField>();
            for (SortField sf : sortFields) {
                String path = sf.getPath().asStringPath();
                if (sortFieldMap.containsKey(path)) continue;
                sortFieldMap.put(path, sf);
            }
            sortFields = sortFieldMap.values().toArray(new SortField[sortFieldMap.size()]);
            translatedSortFields = new ArrayList(sortFields.length);
            for (SortField sortField : sortFields) {
                translatedSortFields.add(this.metadataAdapter.mapPropertyNamePathToFieldIdPath(sortField.getPath().getPath()));
            }
        }
        BooleanExpr normalizedQuery = this.booleanFilterNormalizer.normalize(query);
        BETree bETree = this.treeMaker.make(normalizedQuery, namedParameters);
        FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscription = new FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId>(queryString, namedParameters, this.useIntervals, this.metadataAdapter, bETree, callback, projection, projectionTypes, translatedProjections, sortFields, translatedSortFields, eventTypes);
        filterSubscription.registerProjection(this.predicateIndex);
        filterSubscription.subscribe(this.predicateIndex);
        filterSubscription.index = this.filterSubscriptions.size();
        this.filterSubscriptions.add(filterSubscription);
        return filterSubscription;
    }

    public void removeFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        filterSubscriptionImpl.unregisterProjection(this.predicateIndex);
        filterSubscriptionImpl.unsubscribe(this.predicateIndex);
        this.filterSubscriptions.remove(filterSubscriptionImpl);
        for (int i = filterSubscriptionImpl.index; i < this.filterSubscriptions.size(); ++i) {
            --this.filterSubscriptions.get((int)i).index;
        }
        filterSubscriptionImpl.index = -1;
    }
}

