/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.jboss.logging.Logger;

public final class ProtobufPropertyHelper
extends ObjectPropertyHelper<Descriptor> {
    private static final Log log = Logger.getMessageLogger(Log.class, ProtobufPropertyHelper.class.getName());
    private final SerializationContext serializationContext;

    public ProtobufPropertyHelper(EntityNamesResolver entityNamesResolver, SerializationContext serializationContext) {
        super(entityNamesResolver);
        this.serializationContext = serializationContext;
    }

    @Override
    public Descriptor getEntityMetadata(String targetTypeName) {
        return this.serializationContext.getMessageDescriptor(targetTypeName);
    }

    @Override
    public List<?> mapPropertyNamePathToFieldIdPath(Descriptor messageDescriptor, String[] propertyPath) {
        ArrayList<Integer> translatedPath = new ArrayList<Integer>(propertyPath.length);
        Object md = messageDescriptor;
        for (String prop : propertyPath) {
            FieldDescriptor fd = md.findFieldByName(prop);
            translatedPath.add(fd.getNumber());
            md = fd.getJavaType() == JavaType.MESSAGE ? fd.getMessageType() : null;
        }
        return translatedPath;
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, String[] propertyPath) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        switch (field.getJavaType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_STRING: {
                return byte[].class;
            }
            case ENUM: {
                return Integer.class;
            }
        }
        return null;
    }

    private FieldDescriptor getField(String entityType, String[] propertyPath) {
        Descriptor messageDescriptor;
        try {
            messageDescriptor = this.serializationContext.getMessageDescriptor(entityType);
        }
        catch (Exception e) {
            throw log.getUnknownEntity(entityType);
        }
        int i = 0;
        for (String p : propertyPath) {
            FieldDescriptor field = messageDescriptor.findFieldByName(p);
            if (field == null || ++i == propertyPath.length) {
                return field;
            }
            if (field.getJavaType() != JavaType.MESSAGE) break;
            messageDescriptor = field.getMessageType();
        }
        return null;
    }

    @Override
    public boolean hasProperty(String entityType, String[] propertyPath) {
        Descriptor messageDescriptor;
        try {
            messageDescriptor = this.serializationContext.getMessageDescriptor(entityType);
        }
        catch (Exception e) {
            throw log.getUnknownEntity(entityType);
        }
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = messageDescriptor.findFieldByName(p);
            if (field == null) {
                return false;
            }
            if (field.getJavaType() != JavaType.MESSAGE) break;
            messageDescriptor = field.getMessageType();
        }
        return i == propertyPath.length;
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, String[] propertyPath) {
        Descriptor messageDescriptor;
        try {
            messageDescriptor = this.serializationContext.getMessageDescriptor(entityType);
        }
        catch (Exception e) {
            throw log.getUnknownEntity(entityType);
        }
        for (String p : propertyPath) {
            FieldDescriptor field = messageDescriptor.findFieldByName(p);
            if (field == null) {
                return false;
            }
            if (field.getJavaType() != JavaType.MESSAGE) {
                return false;
            }
            messageDescriptor = field.getMessageType();
        }
        return true;
    }

    @Override
    public boolean isRepeatedProperty(String entityType, String[] propertyPath) {
        String p;
        FieldDescriptor field;
        Descriptor messageDescriptor;
        try {
            messageDescriptor = this.serializationContext.getMessageDescriptor(entityType);
        }
        catch (Exception e) {
            throw log.getUnknownEntity(entityType);
        }
        String[] stringArray = propertyPath;
        int n = stringArray.length;
        for (int i = 0; i < n && (field = messageDescriptor.findFieldByName(p = stringArray[i])) != null; ++i) {
            if (field.isRepeated()) {
                return true;
            }
            if (field.getJavaType() != JavaType.MESSAGE) break;
            messageDescriptor = field.getMessageType();
        }
        return false;
    }

    @Override
    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        FieldDescriptor field = this.getField(entityType, propertyPath.toArray(new String[propertyPath.size()]));
        if (field.getJavaType() == JavaType.BOOLEAN) {
            try {
                return Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException e) {
                return super.convertToPropertyType(entityType, propertyPath, value);
            }
        }
        if (field.getJavaType() == JavaType.ENUM) {
            EnumValueDescriptor enumValue;
            EnumDescriptor enumType = field.getEnumType();
            try {
                enumValue = enumType.findValueByNumber(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                enumValue = enumType.findValueByName(value);
            }
            if (enumValue == null) {
                throw log.getInvalidEnumLiteralException(value, enumType.getFullName());
            }
            return enumValue.getNumber();
        }
        return super.convertToPropertyType(entityType, propertyPath, value);
    }
}

