/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;

class FilterComparisonPredicate
extends ComparisonPredicate<BooleanExpr> {
    private final ValueExpr valueExpr;

    FilterComparisonPredicate(ValueExpr valueExpr, ComparisonPredicate.Type comparisonType, Object comparisonValue) {
        super(valueExpr.toJpaString(), comparisonType, comparisonValue);
        this.valueExpr = valueExpr;
    }

    @Override
    protected BooleanExpr getStrictlyLessQuery() {
        return new ComparisonExpr(this.valueExpr, new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.LESS);
    }

    @Override
    protected BooleanExpr getLessOrEqualsQuery() {
        return new ComparisonExpr(this.valueExpr, new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.LESS_OR_EQUAL);
    }

    @Override
    protected BooleanExpr getEqualsQuery() {
        return new ComparisonExpr(this.valueExpr, new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.EQUAL);
    }

    @Override
    protected BooleanExpr getGreaterOrEqualsQuery() {
        return new ComparisonExpr(this.valueExpr, new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.GREATER_OR_EQUAL);
    }

    @Override
    protected BooleanExpr getStrictlyGreaterQuery() {
        return new ComparisonExpr(this.valueExpr, new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.GREATER);
    }
}

