/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.SingleEntityHavingQueryBuilder;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ParentPredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.predicate.FilterComparisonPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterConjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterDisjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterInPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterIsNullPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterLikePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterNegationPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRangePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRootPredicate;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.jboss.logging.Logger;

public final class SingleEntityHavingQueryBuilderImpl
implements SingleEntityHavingQueryBuilder<BooleanExpr> {
    private static final Log log = Logger.getMessageLogger(Log.class, SingleEntityHavingQueryBuilderImpl.class.getName());
    private final EntityNamesResolver entityNamesResolver;
    private final ObjectPropertyHelper propertyHelper;
    private String entityType;
    private RootPredicate<BooleanExpr> rootPredicate;
    private final Stack<ParentPredicate<BooleanExpr>> predicates = new Stack();

    public SingleEntityHavingQueryBuilderImpl(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    @Override
    public void setEntityType(String entityType) {
        if (this.entityNamesResolver.getClassFromName(entityType) == null) {
            throw log.getUnknownEntity(entityType);
        }
        this.entityType = entityType;
        this.rootPredicate = new FilterRootPredicate();
        this.predicates.push(this.rootPredicate);
    }

    @Override
    public void addComparisonPredicate(AggregationPropertyPath.Type aggregationType, List<String> propertyPath, ComparisonPredicate.Type comparisonType, Object value) {
        Object typedValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, value);
        this.pushPredicate(new FilterComparisonPredicate(this.makePropertyValueExpr(this.entityType, propertyPath, aggregationType), comparisonType, typedValue));
    }

    @Override
    public void addRangePredicate(AggregationPropertyPath.Type aggregationType, List<String> propertyPath, Object lower, Object upper) {
        Object lowerValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, lower);
        Object upperValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, upper);
        this.pushPredicate(new FilterRangePredicate(this.makePropertyValueExpr(this.entityType, propertyPath, aggregationType), lowerValue, upperValue));
    }

    @Override
    public void addInPredicate(AggregationPropertyPath.Type aggregationType, List<String> propertyPath, List<Object> elements) {
        ArrayList<Object> typedElements = new ArrayList<Object>(elements.size());
        for (Object element : elements) {
            typedElements.add(this.propertyHelper.convertToBackendType(this.entityType, propertyPath, element));
        }
        this.pushPredicate(new FilterInPredicate(this.makePropertyValueExpr(this.entityType, propertyPath, aggregationType), typedElements));
    }

    @Override
    public void addLikePredicate(AggregationPropertyPath.Type aggregationType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        this.pushPredicate(new FilterLikePredicate(this.makePropertyValueExpr(this.entityType, propertyPath, aggregationType), patternValue, escapeCharacter));
    }

    @Override
    public void addIsNullPredicate(AggregationPropertyPath.Type aggregationType, List<String> propertyPath) {
        this.pushPredicate(new FilterIsNullPredicate(this.makePropertyValueExpr(this.entityType, propertyPath, aggregationType)));
    }

    @Override
    public void pushAndPredicate() {
        this.pushPredicate(new FilterConjunctionPredicate());
    }

    @Override
    public void pushOrPredicate() {
        this.pushPredicate(new FilterDisjunctionPredicate());
    }

    @Override
    public void pushNotPredicate() {
        this.pushPredicate(new FilterNegationPredicate());
    }

    private void pushPredicate(Predicate<BooleanExpr> predicate) {
        this.predicates.peek().add(predicate);
        if (predicate.getType().isParent()) {
            ParentPredicate parentPredicate = predicate.as(ParentPredicate.class);
            this.predicates.push(parentPredicate);
        }
    }

    @Override
    public void popBooleanPredicate() {
        this.predicates.pop();
    }

    @Override
    public BooleanExpr build() {
        return (BooleanExpr)this.rootPredicate.getQuery();
    }

    private PropertyValueExpr makePropertyValueExpr(String entityType, List<String> propertyPath, AggregationPropertyPath.Type aggregationType) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        boolean isRepeated = this.propertyHelper.isRepeatedProperty(entityType, path);
        Class<?> primitiveType = this.propertyHelper.getPrimitivePropertyType(entityType, path);
        if (aggregationType != null) {
            return new AggregationExpr(PropertyPath.AggregationType.from(aggregationType), path, isRepeated, primitiveType);
        }
        return new PropertyValueExpr(path, isRepeated, primitiveType);
    }

    public String toString() {
        return "SingleEntityHavingQueryBuilderImpl[entityType=" + this.entityType + ", rootPredicate=" + this.rootPredicate + "]";
    }
}

