/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.io.IOException;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.infinispan.Cache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryExtractorUtil {
    private static final Log log = (Log)LogFactory.getLog(QueryExtractorUtil.class, Log.class);

    private QueryExtractorUtil() {
    }

    public static Object extractKey(DocumentExtractor extractor, Cache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, int docIndex) {
        String bufferDocumentId;
        try {
            bufferDocumentId = (String)((Object)extractor.extract(docIndex).getId());
        }
        catch (IOException e) {
            log.error("Error while extracting key...", e);
            return null;
        }
        Object key = keyTransformationHandler.stringToKey(bufferDocumentId, cache.getAdvancedCache().getClassLoader());
        return key;
    }
}

