/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.indexmanager.ClusteredSwitchingBackend;
import org.infinispan.query.indexmanager.IndexManagerBasedLockController;
import org.infinispan.query.indexmanager.LocalBackendFactory;
import org.infinispan.query.indexmanager.LocalOnlyBackend;
import org.infinispan.query.indexmanager.SimpleLocalBackendFactory;
import org.infinispan.query.indexmanager.SwitchingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.logging.LogFactory;

final class InfinispanBackendQueueProcessor
extends WorkspaceHolder {
    private static final Log log = (Log)LogFactory.getLog(InfinispanBackendQueueProcessor.class, Log.class);
    private ServiceManager serviceManager;
    private String indexName;
    private IndexManager indexManager;
    private SwitchingBackend forwardingBackend;

    InfinispanBackendQueueProcessor() {
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.indexManager = indexManager;
        SimpleLocalBackendFactory localBackendFactory = new SimpleLocalBackendFactory(indexManager, props, context);
        this.serviceManager = context.getServiceManager();
        CacheManagerService cacheManagerService = this.serviceManager.requestService(CacheManagerService.class);
        this.indexName = indexManager.getIndexName();
        ComponentRegistryService componentRegistryService = this.serviceManager.requestService(ComponentRegistryService.class);
        ComponentRegistry componentRegistry = componentRegistryService.getComponentRegistry();
        this.forwardingBackend = InfinispanBackendQueueProcessor.createForwardingBackend(props, componentRegistry, this.indexName, localBackendFactory, cacheManagerService, indexManager);
        log.commandsBackendInitialized(this.indexName);
    }

    private static SwitchingBackend createForwardingBackend(Properties props, ComponentRegistry componentRegistry, String indexName, LocalBackendFactory localBackendFactory, CacheManagerService cacheManagerService, IndexManager indexManager) {
        RpcManager rpcManager = (RpcManager)componentRegistry.getComponent(RpcManager.class);
        if (rpcManager == null) {
            LocalOnlyBackend backend = new LocalOnlyBackend(localBackendFactory);
            backend.initialize();
            return backend;
        }
        EmbeddedCacheManager embeddedCacheManager = cacheManagerService.getEmbeddedCacheManager();
        TransactionManager transactionManager = (TransactionManager)componentRegistry.getComponent(TransactionManager.class);
        DirectoryBasedIndexManager directoryBasedIndexManager = (DirectoryBasedIndexManager)indexManager;
        IndexManagerBasedLockController lockControl = new IndexManagerBasedLockController(directoryBasedIndexManager, transactionManager);
        ClusteredSwitchingBackend backend = new ClusteredSwitchingBackend(props, componentRegistry, indexName, localBackendFactory, lockControl);
        backend.initialize();
        embeddedCacheManager.addListener((Object)backend);
        return backend;
    }

    @Override
    public void close() {
        this.forwardingBackend.shutdown();
        this.serviceManager.releaseService(CacheManagerService.class);
        this.serviceManager.releaseService(ComponentRegistryService.class);
        this.serviceManager = null;
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        try {
            this.forwardingBackend.getCurrentIndexingBackend().applyWork(workList, monitor, this.indexManager);
        }
        catch (SuspectException e) {
            this.forwardingBackend.refresh();
            this.forwardingBackend.getCurrentIndexingBackend().applyWork(workList, monitor, this.indexManager);
        }
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.forwardingBackend.getCurrentIndexingBackend().applyStreamWork(singleOperation, monitor, this.indexManager);
    }

    @Override
    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not Implementable: nonsense on a distributed index.");
    }

    @Override
    public void indexMappingChanged() {
    }

    boolean isMasterLocal() {
        return this.forwardingBackend.getCurrentIndexingBackend().isMasterLocal();
    }
}

