/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetKeyValueCommand
extends AbstractDataCommand {
    public static final byte COMMAND_ID = 4;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private InternalCacheEntry remotelyFetchedValue;
    private boolean returnEntry;
    private InternalEntryFactory entryFactory;

    public GetKeyValueCommand(Object key, Set<Flag> flags, boolean returnEntry, InternalEntryFactory entryFactory) {
        this.key = key;
        this.flags = flags;
        this.returnEntry = returnEntry;
        this.entryFactory = entryFactory;
    }

    public GetKeyValueCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            if (trace) {
                log.trace("Entry not found");
            }
            return null;
        }
        if (entry.isRemoved()) {
            if (trace) {
                log.tracef("Entry has been deleted and is of type %s", (Object)entry.getClass().getSimpleName());
            }
            return null;
        }
        if (this.returnEntry) {
            CacheEntry copy = this.entryFactory.copy(entry);
            if (trace) {
                log.tracef("Found entry %s", (Object)entry);
                log.tracef("Returning copied entry %s", (Object)copy);
            }
            return copy;
        }
        Object value = entry.getValue();
        if (trace) {
            log.tracef("Found value %s", (Object)Util.toStr(value));
        }
        return value;
    }

    @Override
    public byte getCommandId() {
        return 4;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 4) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.flags = (Set)parameters[1];
        this.returnEntry = (Boolean)parameters[2];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, Flag.copyWithoutRemotableFlags(this.flags), this.returnEntry};
    }

    public void setRemotelyFetchedValue(InternalCacheEntry remotelyFetchedValue) {
        this.remotelyFetchedValue = remotelyFetchedValue;
    }

    public InternalCacheEntry getRemotelyFetchedValue() {
        return this.remotelyFetchedValue;
    }

    public boolean isReturnEntry() {
        return this.returnEntry;
    }

    @Override
    public String toString() {
        return "GetKeyValueCommand {key=" + Util.toStr(this.key) + ", flags=" + this.flags + ", returnEntry=" + this.returnEntry + "}";
    }
}

