/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.TimeService;

public class ValuesCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;
    private final TimeService timeService;

    public ValuesCommand(DataContainer container, TimeService timeService, Set<Flag> flags) {
        this.setFlags(flags);
        this.container = container;
        this.timeService = timeService;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitValuesCommand(ctx, this);
    }

    @Override
    public Collection<Object> perform(InvocationContext ctx) throws Throwable {
        if (ctx.getLookedUpEntries().isEmpty()) {
            return new ExpiredFilteredValues(this.container.entrySet(), this.timeService);
        }
        return new FilteredValues(this.container, ctx.getLookedUpEntries(), this.timeService);
    }

    public String toString() {
        return "ValuesCommand{values=" + this.container.size() + " elements" + '}';
    }

    public static class ExpiredFilteredValues
    extends AbstractCollection<Object> {
        final Set<InternalCacheEntry> entrySet;
        final TimeService timeService;

        public ExpiredFilteredValues(Set<InternalCacheEntry> entrySet, TimeService timeService) {
            this.entrySet = entrySet;
            this.timeService = timeService;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            int s = this.entrySet.size();
            long currentTimeMillis = 0L;
            for (InternalCacheEntry e : this.entrySet) {
                if (!e.canExpire()) continue;
                if (currentTimeMillis == 0L) {
                    currentTimeMillis = this.timeService.wallClockTime();
                }
                if (!e.isExpired(currentTimeMillis)) continue;
                --s;
            }
            return s;
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<InternalCacheEntry> it;
            private Object next;

            private Itr() {
                this.it = ExpiredFilteredValues.this.entrySet.iterator();
                this.fetchNext();
            }

            private void fetchNext() {
                long currentTimeMillis = 0L;
                while (this.it.hasNext()) {
                    InternalCacheEntry e = this.it.next();
                    boolean canExpire = e.canExpire();
                    if (canExpire && currentTimeMillis == 0L) {
                        currentTimeMillis = ExpiredFilteredValues.this.timeService.wallClockTime();
                    }
                    if (!canExpire) {
                        this.next = e.getValue();
                        break;
                    }
                    if (e.isExpired(currentTimeMillis)) continue;
                    this.next = e.getValue();
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class FilteredValues
    extends AbstractCollection<Object> {
        final DataContainer<Object, Object> container;
        final Set<InternalCacheEntry> entrySet;
        final Map<Object, CacheEntry> lookedUpEntries;
        final TimeService timeService;

        FilteredValues(DataContainer container, Map<Object, CacheEntry> lookedUpEntries, TimeService timeService) {
            this.container = container;
            this.entrySet = container.entrySet();
            this.lookedUpEntries = lookedUpEntries;
            this.timeService = timeService;
        }

        @Override
        public int size() {
            long currentTimeMillis = 0L;
            HashSet validKeys = new HashSet();
            for (InternalCacheEntry e : this.entrySet) {
                if (e.canExpire()) {
                    if (currentTimeMillis == 0L) {
                        currentTimeMillis = this.timeService.wallClockTime();
                    }
                    if (e.isExpired(currentTimeMillis)) continue;
                    validKeys.add(e.getKey());
                    continue;
                }
                validKeys.add(e.getKey());
            }
            int size = validKeys.size();
            for (CacheEntry e : this.lookedUpEntries.values()) {
                if (validKeys.contains(e.getKey())) {
                    if (!e.isRemoved()) continue;
                    --size;
                    continue;
                }
                if (e.isRemoved()) continue;
                ++size;
            }
            return Math.max(size, 0);
        }

        @Override
        public boolean contains(Object o) {
            for (CacheEntry cacheEntry : this.lookedUpEntries.values()) {
                if (!o.equals(cacheEntry.getValue()) || cacheEntry.isRemoved()) continue;
                return true;
            }
            for (Map.Entry entry : this.container) {
                Object value = entry.getValue();
                if (!o.equals(value) || this.lookedUpEntries.containsKey(entry.getKey())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<CacheEntry> it1;
            private final Iterator<InternalCacheEntry> it2;
            private boolean atIt1;
            private Object next;

            Itr() {
                this.it1 = FilteredValues.this.lookedUpEntries.values().iterator();
                this.it2 = FilteredValues.this.entrySet.iterator();
                this.atIt1 = true;
                this.fetchNext();
            }

            private void fetchNext() {
                boolean found;
                if (this.atIt1) {
                    found = false;
                    while (this.it1.hasNext()) {
                        CacheEntry e = this.it1.next();
                        if (e.isRemoved()) continue;
                        this.next = e.getValue();
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.atIt1 = false;
                    }
                }
                if (!this.atIt1) {
                    found = false;
                    long currentTimeMillis = 0L;
                    while (this.it2.hasNext()) {
                        InternalCacheEntry ice = this.it2.next();
                        Object key = ice.getKey();
                        if (ice.canExpire()) {
                            if (currentTimeMillis == 0L) {
                                currentTimeMillis = FilteredValues.this.timeService.wallClockTime();
                            }
                            if (ice.isExpired(currentTimeMillis)) continue;
                        }
                        if (FilteredValues.this.lookedUpEntries.containsKey(key)) continue;
                        this.next = ice.getValue();
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.next = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

